import { ButtonSize } from "./AiKitButton.styles";
import React from "react";
import { LayoutProps, SpaceProps } from "styled-system";
import { WhiteSpaceProp } from "../../types/WhiteSpaceProp";
export interface InsightsButtonProps extends SpaceProps, LayoutProps {
    /** Show the Sage AI icon */
    showIcon?: boolean;
    /** The size of the button (xs,s,m,l) */
    buttonSize: ButtonSize;
    children?: React.ReactNode;
    /** Button fill colour */
    fillColor?: string;
    /** Button is disabled */
    disabled?: boolean;
    /** Whitespace CSS prop */
    whiteSpace?: WhiteSpaceProp;
}
declare const InsightsButtonImpl: import("styled-components").StyledComponent<React.ForwardRefExoticComponent<Omit<{
    [x: string]: /*elided*/ any;
    theme: import("styled-components").DefaultTheme;
    as: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
    forwardedAs: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
}, "ref"> & React.RefAttributes<HTMLElement>>, import("styled-components").DefaultTheme, InsightsButtonProps, never>;
declare const InsightsButton: ({ showIcon, children, buttonSize, ...rest }: React.ComponentProps<typeof InsightsButtonImpl>) => React.JSX.Element;
export default InsightsButton;
