import { DefaultThemeStylingKey } from "../../themes/default";
import { ButtonSize } from "./AiKitButton.styles";
export type AiKitMinorButtonStyle = "neutral" | "positive" | "negative" | "black" | "neutral-secondary" | "positive-secondary" | "negative-secondary" | "black-secondary" | "neutral-tertiary" | "positive-tertiary" | "negative-tertiary" | "black-tertiary";
export interface ButtonStateColors {
    color: string;
    borderColor: string;
    backgroundColor: string;
    colorHover: string;
    borderColorHover: string;
    backgroundColorHover: string;
    colorActive: string;
    borderColorActive: string;
    backgroundColorActive: string;
    colorDisabled: string;
    borderColorDisabled: string;
    backgroundColorDisabled: string;
}
type ButtonStyleStateColors = {
    [key in AiKitMinorButtonStyle]: ButtonStateColors;
};
interface AiKitMinorButtonSize {
    minHeight: string;
    padding: string;
    fontSizeKey: DefaultThemeStylingKey;
    fontWeightKey: DefaultThemeStylingKey;
}
export type AiKitButtonSizes = {
    [key in ButtonSize]: AiKitMinorButtonSize;
};
export declare const aiKitMinorButtonColors: ButtonStyleStateColors;
export declare const aiKitMinorButtonSizes: AiKitButtonSizes;
interface ButtonBorder {
    borderRadius: string;
    borderWidth: string;
}
export declare const aiKitMinorButtonBorders: {
    [key in AiKitMinorButtonStyle]: ButtonBorder;
};
export {};
