import { DefaultThemeStylingKey } from "../../themes/default";
export type ButtonSize = "xs" | "s" | "m" | "l";
export type ButtonStyle = "green-rounded-major" | "green-rounded-minor" | "black-rounded-major" | "black-rounded-minor" | "black-rectangle" | "red-rounded-major" | "red-rounded-minor";
export type ButtonBackground = "light" | "dark";
export interface ButtonStateColors {
    color: string;
    borderColor: string;
    backgroundColor: string;
    colorHover: string;
    borderColorHover: string;
    backgroundColorHover: string;
    colorActive: string;
    borderColorActive: string;
    backgroundColorActive: string;
    colorDisabled: string;
    borderColorDisabled: string;
    backgroundColorDisabled: string;
}
type ButtonStyleStateColors = {
    [key in ButtonStyle]: ButtonStateColors;
};
type ButtonBackgoundStyleStateColors = {
    [key in ButtonBackground]: ButtonStyleStateColors;
};
interface AiKitButtonSize {
    minWidth: string;
    minHeight: string;
    padding: string;
    fontSizeKey: DefaultThemeStylingKey;
    fontWeightKey: DefaultThemeStylingKey;
}
export type AiKitButtonSizes = {
    [key in ButtonSize]: AiKitButtonSize;
};
export declare const aiKitButtonColors: ButtonBackgoundStyleStateColors;
export declare const aiKitButtonSizes: AiKitButtonSizes;
interface ButtonBorder {
    borderRadius: string;
    borderWidth: string;
}
export declare const aiKitButtonBorders: {
    [key in ButtonStyle]: ButtonBorder;
};
export {};
