import { MakeAiMessage } from "./CopilotBackendMocks";
import { SessionMessageJson } from "../interface/SessionMessageBuilder";
import { UUIDType } from "../../../types/SessionMessage";
export interface CreateMessageFnParams {
    sessionId: string;
    messageId: UUIDType;
    timestamp: string;
    makeAiMessage: MakeAiMessage;
    makeSystemMessage: MakeAiMessage;
    proxyUrl: string;
}
type CreateMessageFn = (params: CreateMessageFnParams) => SessionMessageJson;
type MockMessageDispatchEntry = {
    createMessageFn: CreateMessageFn;
    helpText: string;
    isSuggestedPrompt: boolean;
};
type MockMessageDispatchLookup = Record<string, MockMessageDispatchEntry>;
export declare const mockMessageDispatchLookup: MockMessageDispatchLookup;
export declare const mockDispatchQuestion: (params: CreateMessageFnParams & {
    message: string;
}) => SessionMessageJson;
export {};
