import { InsightMessageReadStatus, InsightSessionMessage, MessageFeedback, SessionMessage, TagType, UUIDType } from "../../../types/SessionMessage";
import { SpeakerType } from "../../../types/SpeakerType";
import { FeedbackTag } from "../../../types/FeedbackTags";
import { MessagePartTypesJson } from "./MessagePartsJson";
import { IMessagePartBase } from "../../../types/SessionMessageParts";
export interface InsightsFeedResponseJson {
    insights: SessionMessageJson[];
    unread_count: number;
}
export interface ChatStreamResponse {
    messages: SessionMessageJson[];
    stream_key: string;
}
export interface SessionMessageJson {
    message_id: string;
    session_id: string;
    session_name?: string;
    speaker: SpeakerType;
    message: string;
    message_parts?: MessagePartTypesJson[];
    created_at: string;
    trace_id?: string;
    feedback: MessageFeedback;
    feedback_tags?: FeedbackTag[];
    feedback_text?: string;
    status?: InsightMessageReadStatus;
    regeneratable?: boolean;
    response_stream_key?: string;
}
export interface ServerSentEventJson {
    type: "chunk" | "complete";
    content: string;
    timestamp: number;
}
export declare class SessionMessageBuilder implements SessionMessage {
    message_id: UUIDType;
    speaker: SpeakerType;
    created_at: Date;
    message?: string;
    message_parts: IMessagePartBase[];
    tag: TagType;
    hasFeedback: boolean;
    regeneratable: boolean;
    response_stream_key?: string;
    trace_id: UUIDType | undefined;
    constructor(json: SessionMessageJson, tag: TagType, responseStreamKey?: string);
}
export declare class InsightSessionMessageBuilder extends SessionMessageBuilder {
    session_id: UUIDType;
    session_name?: string;
    status: InsightMessageReadStatus;
    constructor(json: SessionMessageJson, tag: TagType);
}
export declare const createSessionMessages: (json: SessionMessageJson[], tag: TagType, responseStreamKey?: string) => SessionMessage[];
export declare const createInsightSessionMessages: (json: SessionMessageJson[]) => InsightSessionMessage[];
