import { BarChartData, BarChartOptions, LineChartData, LineChartOptions, PieChartData, PieChartOptions } from "@sageai/chartist";
import { UUIDType } from "../../../types/SessionMessage";
import { DetailSeparatorBehavior, GenericLegacyTableCellKind, IGenericHtmlTableCell, IGenericLegacyTableCell, IGenericTableCell, IGenericTableRow, IMessagePartBase, IMessagePartChartCopilotOptions, IMessagePartPrompt, IMessagePartSubmit, IMessagePartTable, IMessagePartText, IStyledPrompt, ITableData, ITableIcon, ITableLink, MessagePartDisplayArea, MessagePartHyperLinkStyle, MessagePartHyperLinkType, MessagePartTableRowKind, TableCellAlignment, TableCellStyle, TableCellTextWrapping, TableCellWidth, TableIconKind, TableIconPosition } from "../../../types/SessionMessageParts";
import DataRoleCounter from "./DataRoleCounter";
import { SageIconType } from "../../../types/SageIconType";
import { LinkIconColor } from "../../../types/LinkIconColors";
import { IHyperLinkOptions } from "../../../types/SessionMessageParts";
export declare const parseSessionMessageDate: (dateStr: string) => Date;
export interface IMessagePartBaseJson {
    message_part_id: string;
    message_id: string;
    part_index: number;
    kind: string;
    created_at: string;
    display_area?: MessagePartDisplayArea;
}
export interface IMessagePartTextJson extends IMessagePartBaseJson {
    kind: "text";
    text: string;
    lhs_icon?: SageIconType;
    lhs_icon_color?: LinkIconColor;
}
interface IMessagePartIFrameJson extends IMessagePartBaseJson {
    kind: "iframe";
    text: string;
}
interface IMessagePartExplanationJson extends IMessagePartBaseJson {
    kind: "explanation";
    text: string;
}
interface IMessagePartSummaryJson extends IMessagePartBaseJson {
    kind: "summary";
    text: string;
}
interface IMessagePartHyperlinkJson extends IMessagePartBaseJson {
    kind: "hyperlink";
    text: string;
    url: string;
    link_type?: MessagePartHyperLinkType;
    link_style?: MessagePartHyperLinkStyle;
    show_icon?: boolean;
    icon?: SageIconType;
    icon_color?: LinkIconColor;
    link_options?: IHyperLinkOptions;
    data_role?: string;
}
interface IMessagePartDetailSeparatorJson extends IMessagePartBaseJson {
    kind: "detail_separator";
    text: string;
    link_style?: MessagePartHyperLinkStyle;
    show_icon?: boolean;
    behavior?: DetailSeparatorBehavior;
}
interface IMessagePartIntacctCloseHeadingJson extends IMessagePartBaseJson {
    kind: "intacct_close_heading";
    text: string;
    update_ts: string;
}
export interface IStyledPromptJson {
    prompt: string;
    alt_display_text?: string;
    style?: MessagePartHyperLinkStyle;
    icon?: SageIconType;
    icon_color?: LinkIconColor;
    data_role?: string;
    canonical_question_id?: string;
}
export interface IMessagePartPromptJson extends IMessagePartBaseJson {
    kind: "prompt";
    prompts: (string | IStyledPromptJson)[];
}
interface IMessagePartChartJson extends IMessagePartBaseJson {
    kind: "chart";
    chart_data: IMessagePartChartDataJson;
}
interface IMessagePartBarChartDataJson {
    kind: "bar";
    data: BarChartData;
    options?: BarChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
interface IMessagePartLineChartDataJson {
    kind: "line";
    data: LineChartData;
    options?: LineChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
interface IMessagePartPieChartDataJson {
    kind: "pie";
    data: PieChartData;
    options?: PieChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
type IMessagePartChartDataJson = IMessagePartBarChartDataJson | IMessagePartLineChartDataJson | IMessagePartPieChartDataJson;
export interface IMessagePartTableJson extends IMessagePartBaseJson {
    kind: "table";
    table_data: ITableDataJson;
}
interface IMessagePartTitleJson extends IMessagePartBaseJson {
    kind: "title";
    text: string;
}
interface IMessagePartSubmitBaseJson extends IMessagePartBaseJson {
    key: string;
    label?: string;
    required?: boolean;
}
interface IMessagePartSubmitTextJson extends IMessagePartSubmitBaseJson {
    kind: "submit_text";
}
interface IMessagePartSubmitSelectJson extends IMessagePartSubmitBaseJson {
    kind: "submit_select";
    options: {
        label: string;
        value: string;
    }[];
    placeholder?: string;
}
export interface IMessagePartSubmitJson extends IMessagePartBaseJson {
    kind: "submit";
    prompt_text: string | IStyledPromptJson;
    button_text: string;
    data_role?: string;
}
interface IMessagePartPollInsightsJson extends IMessagePartBaseJson {
    kind: "poll_insights";
    stop_condition: "new_insight";
    initial_wait_seconds: number;
    wait_seconds: number;
    timeout_seconds: number;
}
export interface IMessagePartProxiedQueryDefinitionJson extends IMessagePartBaseJson {
    kind: "proxied_query_definition";
    method: "POST" | "GET";
    url: string;
    headers?: {
        [key: string]: string;
    } | null;
    params?: {
        [key: string]: string;
    } | null;
    body?: object | null;
    state?: object | null;
    timeout_seconds?: number | null;
}
export interface ITableDataJson {
    kind: "generic_table";
    headings?: (IGenericTableHeadingJson | IGenericLegacyTableCellJson | IGenericHtmlTableCellJson)[];
    rows: IGenericTableRowJson[];
}
interface ITableRowBaseJson {
    kind: MessagePartTableRowKind;
    row_id?: string;
}
interface IGenericTableRowJson extends ITableRowBaseJson {
    kind: "generic_row";
    cells: (IGenericLegacyTableCellJson | IGenericHtmlTableCellJson)[];
}
interface IGenericHtmlTableCellJson {
    kind: "html";
    cell_id: string;
    content_html: string;
    width?: TableCellWidth;
    align: TableCellAlignment;
}
interface IGenericTableCellBaseJson {
    kind: GenericLegacyTableCellKind;
    cell_id: string;
    value: string | ITableLinkJson;
    align: TableCellAlignment;
    wrap?: TableCellTextWrapping;
    icon?: ITableIconJson;
    width?: TableCellWidth;
    style?: TableCellStyle;
}
export interface IGenericLegacyTableCellJson extends IGenericTableCellBaseJson {
    sub_cell?: IGenericTableCellBaseJson;
}
export interface IGenericTableHeadingJson {
    text: string;
    align: TableCellAlignment;
    cell_id: string;
    width?: TableCellWidth;
    wrap?: TableCellTextWrapping;
}
interface ITableLinkJson {
    kind: "table_link";
    text: string;
    url: string;
    link_type?: MessagePartHyperLinkType;
    link_style?: MessagePartHyperLinkStyle;
    show_icon?: boolean;
    data_role?: string;
    link_options?: IHyperLinkOptions;
}
interface ITableIconJson {
    kind: TableIconKind;
    position: TableIconPosition;
    color?: TableCellStyle;
}
export type MessagePartTypesJson = IMessagePartTextJson | IMessagePartIFrameJson | IMessagePartExplanationJson | IMessagePartSummaryJson | IMessagePartHyperlinkJson | IMessagePartDetailSeparatorJson | IMessagePartIntacctCloseHeadingJson | IMessagePartPromptJson | IMessagePartTableJson | IMessagePartTitleJson | IMessagePartChartJson | IMessagePartSubmitSelectJson | IMessagePartSubmitTextJson | IMessagePartSubmitJson | IMessagePartPollInsightsJson | IMessagePartProxiedQueryDefinitionJson;
export declare class MessagePartBase implements IMessagePartBase {
    message_part_id: UUIDType;
    message_id: UUIDType;
    part_index: number;
    kind: string;
    created_at: Date;
    display_area: MessagePartDisplayArea;
    constructor(json: IMessagePartBaseJson);
}
export declare class MessagePartText extends MessagePartBase implements IMessagePartText {
    kind: "text";
    text: string;
    lhs_icon: SageIconType | undefined;
    lhs_icon_color: LinkIconColor | undefined;
    constructor(json: IMessagePartTextJson, hyperlinkDataRoleCounter: DataRoleCounter, promptDataRoleCounter: DataRoleCounter, submitDataRoleCounter: DataRoleCounter);
    static addIdToLinksAndPrompts(text: string, hyperlinkDataRoleCounter: DataRoleCounter, hyperlinkDataRoleLabel: string, promptDataRoleCounter: DataRoleCounter, promptDataRoleLabel: string, promptIndexCounter: DataRoleCounter, submitDataRoleLabel: string, submitDataRoleCounter: DataRoleCounter): string;
}
export declare class MessagePartPrompt extends MessagePartBase implements IMessagePartPrompt {
    kind: "prompt";
    prompts: IStyledPrompt[];
    constructor(json: IMessagePartPromptJson, promptDataRoleCounter: DataRoleCounter);
    static buildStyledPrompt(promptJson: string | IStyledPromptJson, promptDataRoleCounter: DataRoleCounter): IStyledPrompt;
}
export declare class MessagePartTable extends MessagePartBase implements IMessagePartTable {
    kind: "table";
    table_data: ITableData;
    constructor(json: IMessagePartTableJson);
}
export declare class GenericTableData implements ITableData {
    kind: "generic_table";
    headings: (IGenericTableCell | IGenericHtmlTableCell)[];
    rows: IGenericTableRow[];
    constructor(json: ITableDataJson);
    static generateHeadingCell(json: IGenericTableHeadingJson | IGenericLegacyTableCellJson | IGenericHtmlTableCellJson, numHeadings: number, dummyDataRoleCounter: DataRoleCounter): GenericTableCell | GenericHtmlTableCell;
}
declare class GenericTableCellBase implements IGenericLegacyTableCell {
    kind: GenericLegacyTableCellKind;
    cell_id: UUIDType;
    value: string | Date | ITableLink;
    align: TableCellAlignment;
    wrap: TableCellTextWrapping;
    icon: TableIcon;
    style: TableCellStyle;
    constructor(json: IGenericLegacyTableCellJson, hyperlinkDataRoleCounter: DataRoleCounter);
}
export declare class GenericTableCell extends GenericTableCellBase implements IGenericTableCell {
    sub_cell?: IGenericLegacyTableCell | undefined;
    width: TableCellWidth;
    constructor(json: IGenericLegacyTableCellJson, numColumns: number, hyperlinkDataRoleCounter: DataRoleCounter);
    static getCellWidth: (jsonWidth: string | undefined, defaultWidth: TableCellWidth) => TableCellWidth;
}
export declare class GenericHtmlTableCell implements IGenericHtmlTableCell {
    kind: "html";
    cell_id: UUIDType;
    content_html: string;
    width: TableCellWidth;
    align: TableCellAlignment;
    constructor(json: IGenericHtmlTableCellJson, numColumns: number, hyperlinkDataRoleCounter: DataRoleCounter, promptDataRoleCounter: DataRoleCounter, promptIndexCounter: DataRoleCounter, submitDataRoleCounter: DataRoleCounter);
}
declare class TableIcon implements ITableIcon {
    kind: TableIconKind;
    position: TableIconPosition;
    color: TableCellStyle | undefined;
    constructor(json: ITableIconJson);
}
export declare class MessagePartSubmit extends MessagePartBase implements IMessagePartSubmit {
    kind: "submit";
    prompt_text: IStyledPrompt;
    constructor(json: IMessagePartSubmitJson, submitDataRoleCounter: DataRoleCounter);
    static buildSubmitStyledPrompt(json: IMessagePartSubmitJson, submitDataRoleCounter: DataRoleCounter): IStyledPrompt;
}
export declare const createMessageParts: (json: MessagePartTypesJson[] | null | undefined) => IMessagePartBase[];
export {};
