import { ChatRequest, ChatResponse, ProxiedQueryResultRequest } from "../../../types/ChatRequest";
import { InsightPatch, InsightRequestTypes } from "../../../types/Insights";
import { MessagePatch } from "../../../types/MessagePatch";
import { Session, SessionIdType, SessionPatch } from "../../../types/Session";
import { InsightSessionMessage, SessionMessage, UUIDType } from "../../../types/SessionMessage";
import { StarterSessionMessage } from "../../../types/StarterSessionMessage";
import { BackendSettings } from "../../../contexts/BackendContext";
import { BackendInterface } from "../../../contexts/backend/BackendInterface";
import { SessionMessageJson } from "./SessionMessageBuilder";
import { FetchMethod, UpdateMethod } from "../../../types/RequestMethod";
import BackendFetch, { BackendServiceParams, RetryOptions } from "../../BackendFetch";
import { RequestReason } from "../../../types/RequestReason";
import { ChatContext } from "../../../types/ChatContext";
import { AutocompleteSuggestion } from "../../../types/AutocompleteSuggestion";
import { ServerConfig } from "../../../types/ServerConfig";
export declare const STANDARD_RETRY_OPTIONS: RetryOptions;
export declare const transformSession: (sessionMessages: SessionMessageJson[]) => SessionMessage[];
export declare const transformInsights: (sessionMessages: SessionMessageJson[]) => InsightSessionMessage[];
export declare class CopilotBackend extends BackendFetch implements BackendInterface {
    constructor(backendSettings: BackendSettings);
    getMessages(sessionId: SessionIdType, lastSeen: Date | null, limit: number): Promise<SessionMessage[]>;
    getConversationStarter(reason: RequestReason): Promise<StarterSessionMessage>;
    getSuggestedPrompts(reason: RequestReason): Promise<import("../../../types/SuggestedPrompt").SuggestedPrompt[]>;
    postSuggestedPrompts(context: ChatContext, reason: RequestReason): Promise<import("../../../types/SuggestedPrompt").SuggestedPrompt[]>;
    patchMessage(messageId: string, messagePatch: MessagePatch): Promise<void>;
    getSessions(reason: RequestReason): Promise<Session[]>;
    patchSession(sessionId: string, sessionPatch: SessionPatch): Promise<void>;
    deleteSession(sessionId: string): Promise<void>;
    chat(request: ChatRequest | ProxiedQueryResultRequest, onAsyncMessages?: (sessionId: SessionIdType, messages: SessionMessage[]) => void, onAsyncError?: (sessionId: SessionIdType, humanMessage: string) => void, streaming?: boolean): Promise<ChatResponse>;
    private subscribeToSessionEvents;
    getInsights(request: InsightRequestTypes, reason?: RequestReason): Promise<InsightSessionMessage[]>;
    patchInsights(insightId: string, insightPatch: InsightPatch): Promise<void>;
    getInsightsFeed(lastSeen: Date | null, limit: number, reason?: RequestReason): Promise<{
        insights: InsightSessionMessage[];
        unreadCount: number;
    }>;
    postAutocompleteSuggestions(reason: RequestReason, sessionId: string, message: string): Promise<AutocompleteSuggestion[]>;
    getServerConfig(reason: RequestReason): Promise<ServerConfig>;
    get name(): string;
    getRequestHeaders(endpoint: string, requestMethod: UpdateMethod | FetchMethod, reason: RequestReason, correlationId: UUIDType | undefined): Promise<Headers>;
    getBackendEndpointUrl(endpoint: string): string;
    getExtraRequestParams(_endpoint: string): BackendServiceParams;
    hasValidChatContext(): boolean;
}
