import HttpStatusCode from "../constants/HttpStatusCode";
import { BackendSettings } from "../contexts/BackendContext";
import { MaybeCorrelationId } from "../types/ChatRequest";
import { FetchMethod, UpdateMethod } from "../types/RequestMethod";
import { RequestReason } from "../types/RequestReason";
import { UUIDType } from "../types/SessionMessage";
export interface BackendServiceParams {
    [key: string]: string;
}
export interface RetryOptions {
    maxRetries: number;
    allowedStatusCodes: HttpStatusCode[];
    retryAfterIfNoHeader?: number;
}
type TBackendFetchResult<TResponseData> = {
    headers: Headers;
    data: TResponseData;
};
export interface ITraceAnnotatedError extends Error {
    requestId: string | null | undefined;
    correlationId: string | null | undefined;
    sessionId: string | undefined;
    traceId: string | undefined;
    messageId: string | undefined;
}
export declare class BackendError extends Error {
    httpStatusCode: number;
    headers: Headers;
    correlationId?: UUIDType;
    requestId?: UUIDType;
    constructor(message: string, httpStatusCode: number, headers: Headers);
}
export declare const paramsToString: (params: BackendServiceParams | undefined | null) => string;
declare class BackendFetch {
    backendSettings: BackendSettings;
    constructor(backendSettings: BackendSettings);
    setBackendSettings(settings: BackendSettings): void;
    _fetchFromBackend<TResponseData, TRequestData>(endpoint: string, params?: BackendServiceParams, method?: FetchMethod, data?: TRequestData & MaybeCorrelationId, reason?: RequestReason, retryOptions?: RetryOptions): Promise<TBackendFetchResult<TResponseData>>;
    fetchFromBackend<TResponseData, TRequestData>(endpoint: string, params?: BackendServiceParams, method?: FetchMethod, data?: TRequestData & MaybeCorrelationId, reason?: RequestReason, retryOptions?: RetryOptions): Promise<TBackendFetchResult<TResponseData>>;
    updateBackend<TData, TResponseData>(endpoint: string, data: TData & MaybeCorrelationId, method?: UpdateMethod, reason?: RequestReason, retryOptions?: RetryOptions): Promise<TBackendFetchResult<TResponseData>>;
    getRequestHeaders(_endpoint: string, requestMethod: UpdateMethod | FetchMethod, _reason: RequestReason, correlationId: UUIDType | undefined): Promise<Headers>;
    getBackendEndpointUrl(_endpoint: string): string;
    getExtraRequestParams(_endpoint: string): BackendServiceParams;
}
export default BackendFetch;
