export default {
    rules: {
        'accessor-pairs': 'off',
        'array-callback-return': [
            'error',
            {
                allowImplicit: true,
            },
        ],
        'block-scoped-var': 'error',
        complexity: ['off', 20],
        'class-methods-use-this': [
            'error',
            {
                exceptMethods: [
                    'render',
                    'getInitialState',
                    'getDefaultProps',
                    'getChildContext',
                    'componentWillMount',
                    'UNSAFE_componentWillMount',
                    'componentDidMount',
                    'componentWillReceiveProps',
                    'UNSAFE_componentWillReceiveProps',
                    'shouldComponentUpdate',
                    'componentWillUpdate',
                    'UNSAFE_componentWillUpdate',
                    'componentDidUpdate',
                    'componentWillUnmount',
                    'componentDidCatch',
                    'getSnapshotBeforeUpdate',
                ],
            },
        ],
        'consistent-return': 'error',
        'default-case': [
            'error',
            {
                commentPattern: '^no default$',
            },
        ],
        'default-case-last': 'error',
        'default-param-last': 'error',
        'dot-notation': [
            'error',
            {
                allowKeywords: true,
            },
        ],
        eqeqeq: [
            'error',
            'always',
            {
                null: 'ignore',
            },
        ],
        'grouped-accessor-pairs': 'error',
        'guard-for-in': 'error',
        'max-classes-per-file': ['error', 1],
        'no-alert': 'warn',
        'no-caller': 'error',
        'no-case-declarations': 'error',
        'no-constructor-return': 'error',
        'no-div-regex': 'off',
        'no-else-return': [
            'error',
            {
                allowElseIf: false,
            },
        ],
        'no-empty-function': [
            'error',
            {
                allow: ['arrowFunctions', 'functions', 'methods'],
            },
        ],
        'no-empty-pattern': 'error',
        'no-eq-null': 'off',
        'no-eval': 'error',
        'no-extend-native': 'error',
        'no-extra-bind': 'error',
        'no-extra-label': 'error',
        'no-fallthrough': 'error',
        'no-global-assign': [
            'error',
            {
                exceptions: [],
            },
        ],
        'no-native-reassign': 'off',
        'no-implicit-coercion': [
            'off',
            {
                boolean: false,
                number: true,
                string: true,
                allow: [],
            },
        ],
        'no-implicit-globals': 'off',
        'no-implied-eval': 'error',
        'no-invalid-this': 'off',
        'no-iterator': 'error',
        'no-labels': [
            'error',
            {
                allowLoop: false,
                allowSwitch: false,
            },
        ],
        'no-lone-blocks': 'error',
        'no-loop-func': 'error',
        'no-magic-numbers': [
            'off',
            {
                ignore: [],
                ignoreArrayIndexes: true,
                enforceConst: true,
                detectObjects: false,
            },
        ],
        'no-multi-str': 'error',
        'no-new': 'error',
        'no-new-func': 'error',
        'no-new-wrappers': 'error',
        'no-nonoctal-decimal-escape': 'error',
        'no-octal': 'error',
        'no-octal-escape': 'error',
        'no-param-reassign': [
            'error',
            {
                props: true,
                ignorePropertyModificationsFor: [
                    'acc',
                    'accumulator',
                    'e',
                    'ctx',
                    'context',
                    'req',
                    'request',
                    'res',
                    'response',
                    '$scope',
                    'staticContext',
                ],
            },
        ],
        'no-proto': 'error',
        'no-redeclare': 'error',
        'no-restricted-properties': [
            'error',
            {
                object: 'arguments',
                property: 'callee',
                message: 'arguments.callee is deprecated',
            },
            {
                object: 'global',
                property: 'isFinite',
                message: 'Please use Number.isFinite instead',
            },
            {
                object: 'self',
                property: 'isFinite',
                message: 'Please use Number.isFinite instead',
            },
            {
                object: 'window',
                property: 'isFinite',
                message: 'Please use Number.isFinite instead',
            },
            {
                object: 'global',
                property: 'isNaN',
                message: 'Please use Number.isNaN instead',
            },
            {
                object: 'self',
                property: 'isNaN',
                message: 'Please use Number.isNaN instead',
            },
            {
                object: 'window',
                property: 'isNaN',
                message: 'Please use Number.isNaN instead',
            },
            {
                property: '__defineGetter__',
                message: 'Please use Object.defineProperty instead.',
            },
            {
                property: '__defineSetter__',
                message: 'Please use Object.defineProperty instead.',
            },
            {
                object: 'Math',
                property: 'pow',
                message: 'Use the exponentiation operator (**) instead.',
            },
        ],
        'no-return-assign': ['error', 'always'],
        'no-script-url': 'error',
        'no-self-assign': [
            'error',
            {
                props: true,
            },
        ],
        'no-self-compare': 'error',
        'no-sequences': 'error',
        'no-throw-literal': 'error',
        'no-unmodified-loop-condition': 'off',
        'no-unused-expressions': [
            'error',
            {
                allowShortCircuit: false,
                allowTernary: false,
                allowTaggedTemplates: false,
            },
        ],
        'no-unused-labels': 'error',
        'no-useless-call': 'off',
        'no-useless-catch': 'error',
        'no-useless-concat': 'error',
        'no-useless-escape': 'error',
        'no-useless-return': 'error',
        'no-void': 'error',
        'no-warning-comments': [
            'off',
            {
                terms: ['todo', 'fixme', 'xxx'],
                location: 'start',
            },
        ],
        'no-with': 'error',
        'prefer-promise-reject-errors': [
            'error',
            {
                allowEmptyReject: true,
            },
        ],
        'prefer-named-capture-group': 'off',
        'prefer-regex-literals': [
            'error',
            {
                disallowRedundantWrapping: true,
            },
        ],
        radix: 'error',
        'require-await': 'off',
        'require-unicode-regexp': 'off',
        'vars-on-top': 'error',
        yoda: 'error',
        'for-direction': 'error',
        'getter-return': [
            'error',
            {
                allowImplicit: true,
            },
        ],
        'no-async-promise-executor': 'error',
        'no-await-in-loop': 'error',
        'no-compare-neg-zero': 'error',
        'no-cond-assign': ['error', 'always'],
        'no-console': 'warn',
        'no-constant-condition': 'warn',
        'no-control-regex': 'error',
        'no-debugger': 'error',
        'no-dupe-args': 'error',
        'no-dupe-else-if': 'error',
        'no-dupe-keys': 'error',
        'no-duplicate-case': 'error',
        'no-empty': 'error',
        'no-empty-character-class': 'error',
        'no-ex-assign': 'error',
        'no-extra-boolean-cast': 'error',
        'no-func-assign': 'error',
        'no-import-assign': 'error',
        'no-inner-declarations': 'error',
        'no-invalid-regexp': 'error',
        'no-irregular-whitespace': 'error',
        'no-misleading-character-class': 'error',
        'no-obj-calls': 'error',
        'no-promise-executor-return': 'error',
        'no-prototype-builtins': 'error',
        'no-regex-spaces': 'error',
        'no-setter-return': 'error',
        'no-sparse-arrays': 'error',
        'no-template-curly-in-string': 'error',
        'no-unreachable': 'error',
        'no-unreachable-loop': [
            'error',
            {
                ignore: [],
            },
        ],
        'no-unsafe-finally': 'error',
        'no-unsafe-negation': 'error',
        'no-unsafe-optional-chaining': [
            'error',
            {
                disallowArithmeticOperators: true,
            },
        ],
        'no-unused-private-class-members': 'off',
        'no-useless-backreference': 'error',
        'no-negated-in-lhs': 'off',
        'require-atomic-updates': 'off',
        'use-isnan': 'error',
        'valid-jsdoc': 'off',
        'valid-typeof': [
            'error',
            {
                requireStringLiterals: true,
            },
        ],
        'callback-return': 'off',
        'global-require': 'off',
        'handle-callback-err': 'off',
        'no-mixed-requires': ['off', false],
        'n/no-deprecated-api': 'error',
        'n/no-path-concat': 'error',
        'no-process-env': 'off',
        'no-process-exit': 'off',
        'no-restricted-modules': 'off',
        'no-sync': 'off',
        camelcase: [
            'error',
            {
                properties: 'never',
                ignoreDestructuring: false,
            },
        ],
        'capitalized-comments': [
            'off',
            'never',
            {
                line: {
                    ignorePattern: '.*',
                    ignoreInlineComments: true,
                    ignoreConsecutiveComments: true,
                },
                block: {
                    ignorePattern: '.*',
                    ignoreInlineComments: true,
                    ignoreConsecutiveComments: true,
                },
            },
        ],
        'consistent-this': 'off',
        'func-name-matching': [
            'off',
            'always',
            {
                includeCommonJSModuleExports: false,
                considerPropertyDescriptor: true,
            },
        ],
        'func-names': 'warn',
        'func-style': ['off', 'expression'],
        'id-denylist': 'off',
        'id-length': 'off',
        'id-match': 'off',
        'line-comment-position': [
            'off',
            {
                position: 'above',
                ignorePattern: '',
                applyDefaultPatterns: true,
            },
        ],
        'max-depth': ['off', 4],
        'max-lines': [
            'off',
            {
                max: 300,
                skipBlankLines: true,
                skipComments: true,
            },
        ],
        'max-lines-per-function': [
            'off',
            {
                max: 50,
                skipBlankLines: true,
                skipComments: true,
                IIFEs: true,
            },
        ],
        'max-nested-callbacks': 'off',
        'max-params': ['off', 3],
        'max-statements': ['off', 10],
        'multiline-comment-style': ['off', 'starred-block'],
        'new-cap': [
            'error',
            {
                newIsCap: true,
                newIsCapExceptions: [],
                capIsNew: false,
                capIsNewExceptions: ['Immutable.Map', 'Immutable.Set', 'Immutable.List'],
            },
        ],
        'newline-after-var': 'off',
        'newline-before-return': 'off',
        'no-array-constructor': 'error',
        'no-bitwise': 'error',
        'no-continue': 'error',
        'no-inline-comments': 'off',
        'no-lonely-if': 'error',
        'no-multi-assign': ['error'],
        'no-negated-condition': 'off',
        'no-nested-ternary': 'error',
        'no-object-constructor': 'error',
        'no-plusplus': 'error',
        'no-restricted-syntax': [
            'error',
            {
                selector: 'ForInStatement',
                message: 'for..in loops iterate over the entire prototype chain, which is virtually never what you want. Use Object.{keys,values,entries}, and iterate over the resulting array.',
            },
            {
                selector: 'ForOfStatement',
                message: 'iterators/generators require regenerator-runtime, which is too heavyweight for this guide to allow them. Separately, loops should be avoided in favor of array iterations.',
            },
            {
                selector: 'LabeledStatement',
                message: 'Labels are a form of GOTO; using them makes code confusing and hard to maintain and understand.',
            },
            {
                selector: 'WithStatement',
                message: '`with` is disallowed in strict mode because it makes code impossible to predict and optimize.',
            },
        ],
        'no-ternary': 'off',
        'no-underscore-dangle': [
            'error',
            {
                allow: ['__REDUX_DEVTOOLS_EXTENSION_COMPOSE__'],
                allowAfterThis: false,
                allowAfterSuper: false,
                enforceInMethodNames: true,
            },
        ],
        'no-unneeded-ternary': [
            'error',
            {
                defaultAssignment: false,
            },
        ],
        'one-var': ['error', 'never'],
        'operator-assignment': ['error', 'always'],
        'padding-line-between-statements': 'off',
        'prefer-exponentiation-operator': 'error',
        'prefer-object-spread': 'error',
        'require-jsdoc': 'off',
        'sort-keys': [
            'off',
            'asc',
            {
                caseSensitive: false,
                natural: true,
            },
        ],
        'sort-vars': 'off',
        '@stylistic/spaced-comment': [
            'error',
            'always',
            {
                line: {
                    exceptions: ['-', '+'],
                    markers: ['=', '!', '/'],
                },
                block: {
                    exceptions: ['-', '+'],
                    markers: ['=', '!', ':', '::'],
                    balanced: true,
                },
            },
        ],
        'unicode-bom': ['error', 'never'],
        'init-declarations': 'off',
        'no-catch-shadow': 'off',
        'no-delete-var': 'error',
        'no-label-var': 'error',
        'no-restricted-globals': [
            'error',
            {
                name: 'isFinite',
                message: 'Use Number.isFinite instead https://github.com/airbnb/javascript#standard-library--isfinite',
            },
            {
                name: 'isNaN',
                message: 'Use Number.isNaN instead https://github.com/airbnb/javascript#standard-library--isnan',
            },
            'addEventListener',
            'blur',
            'close',
            'closed',
            'confirm',
            'defaultStatus',
            'defaultstatus',
            'event',
            'external',
            'find',
            'focus',
            'frameElement',
            'frames',
            'history',
            'innerHeight',
            'innerWidth',
            'length',
            'location',
            'locationbar',
            'menubar',
            'moveBy',
            'moveTo',
            'name',
            'onblur',
            'onerror',
            'onfocus',
            'onload',
            'onresize',
            'onunload',
            'open',
            'opener',
            'opera',
            'outerHeight',
            'outerWidth',
            'pageXOffset',
            'pageYOffset',
            'parent',
            'print',
            'removeEventListener',
            'resizeBy',
            'resizeTo',
            'screen',
            'screenLeft',
            'screenTop',
            'screenX',
            'screenY',
            'scroll',
            'scrollbars',
            'scrollBy',
            'scrollTo',
            'scrollX',
            'scrollY',
            'self',
            'status',
            'statusbar',
            'stop',
            'toolbar',
            'top',
        ],
        'no-shadow': 'error',
        'no-shadow-restricted-names': 'error',
        'no-undef': 'error',
        'no-undef-init': 'error',
        'no-undefined': 'off',
        'no-unused-vars': [
            'error',
            {
                vars: 'all',
                args: 'after-used',
                ignoreRestSiblings: true,
            },
        ],
        'no-use-before-define': [
            'error',
            {
                functions: true,
                classes: true,
                variables: true,
            },
        ],
        'arrow-body-style': [
            'error',
            'as-needed',
            {
                requireReturnForObjectLiteral: false,
            },
        ],
        'constructor-super': 'error',
        'no-class-assign': 'error',
        'no-const-assign': 'error',
        'no-dupe-class-members': 'error',
        'no-duplicate-imports': 'off',
        'no-new-native-nonconstructor': 'error',
        'no-restricted-exports': [
            'error',
            {
                restrictedNamedExports: ['default', 'then'],
            },
        ],
        'no-restricted-imports': [
            'off',
            {
                paths: [],
                patterns: [],
            },
        ],
        'no-this-before-super': 'error',
        'no-useless-computed-key': 'error',
        'no-useless-constructor': 'error',
        'no-useless-rename': [
            'error',
            {
                ignoreDestructuring: false,
                ignoreImport: false,
                ignoreExport: false,
            },
        ],
        'no-var': 'error',
        'object-shorthand': [
            'error',
            'always',
            {
                ignoreConstructors: false,
                avoidQuotes: true,
            },
        ],
        'prefer-arrow-callback': [
            'error',
            {
                allowNamedFunctions: false,
                allowUnboundThis: true,
            },
        ],
        'prefer-const': [
            'error',
            {
                destructuring: 'any',
                ignoreReadBeforeAssign: true,
            },
        ],
        'prefer-destructuring': [
            'error',
            {
                VariableDeclarator: {
                    array: false,
                    object: true,
                },
                AssignmentExpression: {
                    array: true,
                    object: false,
                },
            },
            {
                enforceForRenamedProperties: false,
            },
        ],
        'prefer-numeric-literals': 'error',
        'prefer-reflect': 'off',
        'prefer-rest-params': 'error',
        'prefer-spread': 'error',
        'prefer-template': 'error',
        'require-yield': 'error',
        'sort-imports': [
            'off',
            {
                ignoreCase: false,
                ignoreDeclarationSort: false,
                ignoreMemberSort: false,
                memberSyntaxSortOrder: ['none', 'all', 'multiple', 'single'],
            },
        ],
        'symbol-description': 'error',
        'import/no-unresolved': [
            'error',
            {
                commonjs: true,
                caseSensitive: true,
            },
        ],
        'import/named': 'error',
        'import/default': 'off',
        'import/namespace': 'off',
        'import/export': 'error',
        'import/no-named-as-default': 'error',
        'import/no-named-as-default-member': 'error',
        'import/no-deprecated': 'off',
        'import/no-extraneous-dependencies': [
            'error',
            {
                devDependencies: [
                    'test/**',
                    'tests/**',
                    'spec/**',
                    '**/__tests__/**',
                    '**/__mocks__/**',
                    'test.{js,jsx}',
                    'test-*.{js,jsx}',
                    '**/*{.,_}{test,spec}.{js,jsx}',
                    '**/jest.config.js',
                    '**/jest.setup.js',
                    '**/vue.config.js',
                    '**/webpack.config.js',
                    '**/webpack.config.*.js',
                    '**/rollup.config.js',
                    '**/rollup.config.*.js',
                    '**/gulpfile.js',
                    '**/gulpfile.*.js',
                    '**/Gruntfile{,.js}',
                    '**/protractor.conf.js',
                    '**/protractor.conf.*.js',
                    '**/karma.conf.js',
                    '**/.eslintrc.js',
                ],
                optionalDependencies: false,
            },
        ],
        'import/no-mutable-exports': 'error',
        'import/no-commonjs': 'off',
        'import/no-amd': 'error',
        'import/no-nodejs-modules': 'off',
        'import/first': 'error',
        'import/imports-first': 'off',
        'import/no-duplicates': 'error',
        'import/no-namespace': 'off',
        'import/extensions': [
            'error',
            'ignorePackages',
            {
                js: 'never',
                mjs: 'never',
                jsx: 'never',
            },
        ],
        'import/order': [
            'error',
            {
                groups: [['builtin', 'external', 'internal']],
            },
        ],
        'import/newline-after-import': 'error',
        'import/prefer-default-export': 'error',
        'import/no-restricted-paths': 'off',
        'import/max-dependencies': [
            'off',
            {
                max: 10,
            },
        ],
        'import/no-absolute-path': 'error',
        'import/no-dynamic-require': 'error',
        'import/no-internal-modules': [
            'off',
            {
                allow: [],
            },
        ],
        'import/unambiguous': 'off',
        'import/no-webpack-loader-syntax': 'error',
        'import/no-unassigned-import': 'off',
        'import/no-named-default': 'error',
        'import/no-anonymous-default-export': [
            'off',
            {
                allowArray: false,
                allowArrowFunction: false,
                allowAnonymousClass: false,
                allowAnonymousFunction: false,
                allowLiteral: false,
                allowObject: false,
            },
        ],
        'import/exports-last': 'off',
        'import/group-exports': 'off',
        'import/no-default-export': 'off',
        'import/no-named-export': 'off',
        'import/no-self-import': 'error',
        'import/no-cycle': [
            'error',
            {
                maxDepth: Infinity,
            },
        ],
        'import/no-useless-path-segments': [
            'error',
            {
                commonjs: true,
            },
        ],
        'import/dynamic-import-chunkname': [
            'off',
            {
                importFunctions: [],
                webpackChunknameFormat: '[0-9a-zA-Z-_/.]+',
            },
        ],
        'import/no-relative-parent-imports': 'off',
        'import/no-unused-modules': [
            'off',
            {
                ignoreExports: [],
                missingExports: true,
                unusedExports: true,
            },
        ],
        'import/no-import-module-exports': [
            'error',
            {
                exceptions: [],
            },
        ],
        'import/no-relative-packages': 'error',
        strict: ['error', 'never'],
        'react/display-name': [
            'off',
            {
                ignoreTranspilerName: false,
            },
        ],
        'react/forbid-prop-types': [
            'error',
            {
                forbid: ['any', 'array', 'object'],
                checkContextTypes: true,
                checkChildContextTypes: true,
            },
        ],
        'react/forbid-dom-props': [
            'off',
            {
                forbid: [],
            },
        ],
        'react/jsx-boolean-value': [
            'error',
            'never',
            {
                always: [],
            },
        ],
        'react/jsx-handler-names': [
            'off',
            {
                eventHandlerPrefix: 'handle',
                eventHandlerPropPrefix: 'on',
            },
        ],
        'react/jsx-key': 'off',
        'react/jsx-no-bind': [
            'error',
            {
                ignoreRefs: true,
                allowArrowFunctions: true,
                allowFunctions: false,
                allowBind: false,
                ignoreDOMComponents: true,
            },
        ],
        'react/jsx-no-duplicate-props': [
            'error',
            {
                ignoreCase: true,
            },
        ],
        'react/jsx-no-literals': [
            'off',
            {
                noStrings: true,
            },
        ],
        'react/jsx-no-undef': 'error',
        'react/jsx-pascal-case': [
            'error',
            {
                allowAllCaps: true,
                ignore: [],
            },
        ],
        'react/sort-prop-types': [
            'off',
            {
                ignoreCase: true,
                callbacksLast: false,
                requiredFirst: false,
                sortShapeProp: true,
            },
        ],
        'react/jsx-sort-prop-types': 'off',
        'react/jsx-sort-props': [
            'off',
            {
                ignoreCase: true,
                callbacksLast: false,
                shorthandFirst: false,
                shorthandLast: false,
                noSortAlphabetically: false,
                reservedFirst: true,
            },
        ],
        'react/jsx-sort-default-props': [
            'off',
            {
                ignoreCase: true,
            },
        ],
        'react/jsx-uses-react': ['error'],
        'react/jsx-uses-vars': 'error',
        'react/no-danger': 'warn',
        'react/no-deprecated': ['error'],
        'react/no-did-mount-set-state': 'off',
        'react/no-did-update-set-state': 'error',
        'react/no-will-update-set-state': 'error',
        'react/no-direct-mutation-state': 'off',
        'react/no-is-mounted': 'error',
        'react/no-multi-comp': 'off',
        'react/no-set-state': 'off',
        'react/no-string-refs': 'error',
        'react/no-unknown-property': 'error',
        'react/prefer-es6-class': ['error', 'always'],
        'react/prefer-stateless-function': [
            'error',
            {
                ignorePureComponents: true,
            },
        ],
        'react/prop-types': [
            'error',
            {
                ignore: [],
                customValidators: [],
                skipUndeclared: false,
            },
        ],
        'react/react-in-jsx-scope': 'error',
        'react/require-render-return': 'error',
        'react/self-closing-comp': 'error',
        'react/sort-comp': [
            'error',
            {
                order: [
                    'static-variables',
                    'static-methods',
                    'instance-variables',
                    'lifecycle',
                    '/^handle.+$/',
                    '/^on.+$/',
                    'getters',
                    'setters',
                    '/^(get|set)(?!(InitialState$|DefaultProps$|ChildContext$)).+$/',
                    'instance-methods',
                    'everything-else',
                    'rendering',
                ],
                groups: {
                    lifecycle: [
                        'displayName',
                        'propTypes',
                        'contextTypes',
                        'childContextTypes',
                        'mixins',
                        'statics',
                        'defaultProps',
                        'constructor',
                        'getDefaultProps',
                        'getInitialState',
                        'state',
                        'getChildContext',
                        'getDerivedStateFromProps',
                        'componentWillMount',
                        'UNSAFE_componentWillMount',
                        'componentDidMount',
                        'componentWillReceiveProps',
                        'UNSAFE_componentWillReceiveProps',
                        'shouldComponentUpdate',
                        'componentWillUpdate',
                        'UNSAFE_componentWillUpdate',
                        'getSnapshotBeforeUpdate',
                        'componentDidUpdate',
                        'componentDidCatch',
                        'componentWillUnmount',
                    ],
                    rendering: ['/^render.+$/', 'render'],
                },
            },
        ],
        'react/jsx-no-target-blank': [
            'error',
            {
                enforceDynamicLinks: 'always',
            },
        ],
        'react/jsx-filename-extension': [
            'error',
            {
                extensions: ['.jsx'],
            },
        ],
        'react/jsx-no-comment-textnodes': 'error',
        'react/no-render-return-value': 'error',
        'react/require-optimization': [
            'off',
            {
                allowDecorators: [],
            },
        ],
        'react/no-find-dom-node': 'error',
        'react/forbid-component-props': [
            'off',
            {
                forbid: [],
            },
        ],
        'react/forbid-elements': [
            'off',
            {
                forbid: [],
            },
        ],
        'react/no-danger-with-children': 'error',
        'react/no-unused-prop-types': [
            'error',
            {
                customValidators: [],
                skipShapeProps: true,
            },
        ],
        'react/style-prop-object': 'error',
        'react/no-unescaped-entities': 'error',
        'react/no-children-prop': 'error',
        'react/no-array-index-key': 'error',
        'react/require-default-props': [
            'error',
            {
                forbidDefaultForRequired: true,
            },
        ],
        'react/forbid-foreign-prop-types': [
            'warn',
            {
                allowInPropTypes: true,
            },
        ],
        'react/void-dom-elements-no-children': 'error',
        'react/default-props-match-prop-types': [
            'error',
            {
                allowRequiredDefaults: false,
            },
        ],
        'react/no-redundant-should-component-update': 'error',
        'react/no-unused-state': 'error',
        'react/boolean-prop-naming': [
            'off',
            {
                propTypeNames: ['bool', 'mutuallyExclusiveTrueProps'],
                rule: '^(is|has)[A-Z]([A-Za-z0-9]?)+',
            },
        ],
        'react/no-typos': 'error',
        'react/jsx-curly-brace-presence': [
            'error',
            {
                props: 'never',
                children: 'never',
            },
        ],
        'react/destructuring-assignment': ['error', 'always'],
        'react/no-access-state-in-setstate': 'error',
        'react/button-has-type': [
            'error',
            {
                button: true,
                submit: true,
                reset: false,
            },
        ],
        'react/no-this-in-sfc': 'error',
        'react/jsx-max-depth': 'off',
        'react/no-unsafe': 'off',
        'react/jsx-fragments': ['error', 'syntax'],
        'react/state-in-constructor': ['error', 'always'],
        'react/static-property-placement': ['error', 'property assignment'],
        'react/jsx-props-no-spreading': [
            'error',
            {
                html: 'enforce',
                custom: 'enforce',
                explicitSpread: 'ignore',
                exceptions: [],
            },
        ],
        'react/prefer-read-only-props': 'off',
        'react/jsx-no-script-url': [
            'error',
            [
                {
                    name: 'Link',
                    props: ['to'],
                },
            ],
        ],
        'react/jsx-no-useless-fragment': 'error',
        'react/no-adjacent-inline-elements': 'off',
        'react/function-component-definition': [
            'error',
            {
                namedComponents: ['function-declaration', 'function-expression'],
                unnamedComponents: 'function-expression',
            },
        ],
        'react/jsx-no-constructed-context-values': 'error',
        'react/no-unstable-nested-components': 'error',
        'react/no-namespace': 'error',
        'react/prefer-exact-props': 'error',
        'react/no-arrow-function-lifecycle': 'error',
        'react/no-invalid-html-attribute': 'error',
        'react/no-unused-class-component-methods': 'error',
        'jsx-a11y/accessible-emoji': 'off',
        'jsx-a11y/alt-text': [
            'error',
            {
                elements: ['img', 'object', 'area', 'input[type="image"]'],
                img: [],
                object: [],
                area: [],
                'input[type="image"]': [],
            },
        ],
        'jsx-a11y/anchor-has-content': [
            'error',
            {
                components: [],
            },
        ],
        'jsx-a11y/anchor-is-valid': [
            'error',
            {
                components: ['Link'],
                specialLink: ['to'],
                aspects: ['noHref', 'invalidHref', 'preferButton'],
            },
        ],
        'jsx-a11y/aria-activedescendant-has-tabindex': 'error',
        'jsx-a11y/aria-props': 'error',
        'jsx-a11y/aria-proptypes': 'error',
        'jsx-a11y/aria-role': [
            'error',
            {
                ignoreNonDOM: false,
            },
        ],
        'jsx-a11y/aria-unsupported-elements': 'error',
        'jsx-a11y/autocomplete-valid': [
            'off',
            {
                inputComponents: [],
            },
        ],
        'jsx-a11y/click-events-have-key-events': 'error',
        'jsx-a11y/control-has-associated-label': [
            'error',
            {
                labelAttributes: ['label'],
                controlComponents: [],
                ignoreElements: ['audio', 'canvas', 'embed', 'input', 'textarea', 'tr', 'video'],
                ignoreRoles: [
                    'grid',
                    'listbox',
                    'menu',
                    'menubar',
                    'radiogroup',
                    'row',
                    'tablist',
                    'toolbar',
                    'tree',
                    'treegrid',
                ],
                depth: 5,
            },
        ],
        'jsx-a11y/heading-has-content': [
            'error',
            {
                components: [''],
            },
        ],
        'jsx-a11y/html-has-lang': 'error',
        'jsx-a11y/iframe-has-title': 'error',
        'jsx-a11y/img-redundant-alt': 'error',
        'jsx-a11y/interactive-supports-focus': 'error',
        'jsx-a11y/label-has-associated-control': [
            'error',
            {
                labelComponents: [],
                labelAttributes: [],
                controlComponents: [],
                assert: 'both',
                depth: 25,
            },
        ],
        'jsx-a11y/lang': 'error',
        'jsx-a11y/media-has-caption': [
            'error',
            {
                audio: [],
                video: [],
                track: [],
            },
        ],
        'jsx-a11y/mouse-events-have-key-events': 'error',
        'jsx-a11y/no-access-key': 'error',
        'jsx-a11y/no-autofocus': [
            'error',
            {
                ignoreNonDOM: true,
            },
        ],
        'jsx-a11y/no-distracting-elements': [
            'error',
            {
                elements: ['marquee', 'blink'],
            },
        ],
        'jsx-a11y/no-interactive-element-to-noninteractive-role': [
            'error',
            {
                tr: ['none', 'presentation'],
            },
        ],
        'jsx-a11y/no-noninteractive-element-interactions': [
            'error',
            {
                handlers: ['onClick', 'onMouseDown', 'onMouseUp', 'onKeyPress', 'onKeyDown', 'onKeyUp'],
            },
        ],
        'jsx-a11y/no-noninteractive-element-to-interactive-role': [
            'error',
            {
                ul: ['listbox', 'menu', 'menubar', 'radiogroup', 'tablist', 'tree', 'treegrid'],
                ol: ['listbox', 'menu', 'menubar', 'radiogroup', 'tablist', 'tree', 'treegrid'],
                li: ['menuitem', 'option', 'row', 'tab', 'treeitem'],
                table: ['grid'],
                td: ['gridcell'],
            },
        ],
        'jsx-a11y/no-noninteractive-tabindex': [
            'error',
            {
                tags: [],
                roles: ['tabpanel'],
            },
        ],
        'jsx-a11y/no-onchange': 'off',
        'jsx-a11y/no-redundant-roles': 'error',
        'jsx-a11y/no-static-element-interactions': [
            'error',
            {
                handlers: ['onClick', 'onMouseDown', 'onMouseUp', 'onKeyPress', 'onKeyDown', 'onKeyUp'],
            },
        ],
        'jsx-a11y/role-has-required-aria-props': 'error',
        'jsx-a11y/role-supports-aria-props': 'error',
        'jsx-a11y/scope': 'error',
        'jsx-a11y/tabindex-no-positive': 'error',
        'jsx-a11y/label-has-for': [
            'off',
            {
                components: [],
                required: {
                    every: ['nesting', 'id'],
                },
                allowChildren: false,
            },
        ],
    },
};
