import * as React from 'react';
import { connect } from 'react-redux';
import { ConnectedDialogRouter } from './component/container/dialog/dialog-router';
import PageComponent from './component/container/page/page-component';
import { ConnectedToastComponent } from './component/toast/toast-component';
import { ContextType } from './types';
import { getPageBodyColumnCount } from './utils/responsive-utils';
import { getMainPageDefinitionFromState } from './utils/state-utils';
import { LoadingSkeleton } from './component/skeleton/loading-skeleton';
import { NEW_PAGE } from './utils/constants';
/** @internal */
class XtremController extends React.Component {
    constructor() {
        super(...arguments);
        this.isFullWidthGrid = () => !this.props.pageDefinition?.selectedRecordId &&
            !(this.props.pageDefinition?.queryParameters?._id === NEW_PAGE) &&
            !this.props.pageDefinition?.navigationPanel?.isHidden &&
            !this.props.browserIs.xs;
    }
    renderBody() {
        const gridColumnCount = getPageBodyColumnCount(this.props.browserIs);
        if (this.props.pageDefinition && this.props.pageDefinition.isReady) {
            return (React.createElement(PageComponent, { key: this.props.pageDefinition.metadata.screenId, pageDefinition: this.props.pageDefinition, contextType: ContextType.page, availableColumns: gridColumnCount }));
        }
        return null;
    }
    render() {
        const showNavPanelLoading = !(this.isFullWidthGrid() || this.props.browserIs.s) && this.props.pageDefinition?.isReady;
        const cssClasses = 'e-xtrem-controller';
        return (React.createElement("div", { className: cssClasses, style: !this.props.path && !this.props.loading ? { display: 'none' } : {} },
            this.renderBody(),
            React.createElement(ConnectedDialogRouter, null),
            this.props.loading && React.createElement(LoadingSkeleton, { isNavPanel: showNavPanelLoading }),
            this.props.toasts.map(toast => (React.createElement(ConnectedToastComponent, { key: toast.id, toast: toast })))));
    }
}
/** @internal */
const mapStateToProps = (state) => ({
    path: state.path,
    browserIs: state.browser.is,
    loading: state.loading.globalLoading,
    toasts: state.toasts,
    pageDefinition: getMainPageDefinitionFromState(state),
});
/** @internal */
export const ConnectedXtremController = connect(mapStateToProps)(XtremController);
//# sourceMappingURL=xtrem-controller.js.map