const parameters = {};
window.location.search
    .substring(1)
    .split('&')
    .forEach(s => {
    const parts = s.split('=');
    if (parts[0]) {
        parameters[parts[0]] = parts[1];
    }
});
export const getWindowParameters = () => {
    return Object.seal(parameters);
};
export const getLocalStorage = () => window.localStorage;
export const isNoConsole = () => {
    try {
        return !!process?.env?.NO_CONSOLE;
    }
    catch {
        return false;
    }
};
export const isDevMode = () => window.location?.hostname === 'localhost' ||
    window.location?.hostname === '127.0.0.1' ||
    window.DEBUGGING_XTREM;
export const hasQueryLogging = () => isDevMode() && !window.SKIP_QUERY_LOGGING && !isNoConsole();
export const hasNodeCacheLogging = () => isDevMode() && !window.SKIP_NODE_CACHE_LOGGING && !isNoConsole();
export const hasStateLogging = () => isDevMode() && !window.SKIP_STATE_LOGGING && !isNoConsole();
export const hasAgGridLogging = () => isDevMode() && !window.SKIP_AG_GRID_LOGGING && !isNoConsole();
//# sourceMappingURL=window.js.map