import { cloneDeep, isArray, isPlainObject, reduce } from 'lodash';
export const isNumber = (value) => {
    return typeof value !== 'undefined' && value !== null && !Number.isNaN(Number(value));
};
export const reduceDict = () => (source, initial, onValueFn, onObjectFn, onArrayFn) => {
    const reduceTree = (tree, accumulator, path = [], root = false) => {
        if (root && isArray(tree)) {
            if (onArrayFn) {
                const [remappedValue, remappedPath] = onArrayFn(tree, initial, '', path, source);
                return reduceTree(remappedValue, initial, remappedPath);
            }
        }
        if (root && isPlainObject(tree)) {
            if (onObjectFn) {
                const [remappedValue, remappedPath] = onObjectFn(tree, initial, '', path, source);
                return reduceTree(remappedValue, initial, remappedPath);
            }
        }
        return reduce(tree, (acc, value, key) => {
            const updatedPath = [...path, key];
            if (isArray(value)) {
                if (onArrayFn) {
                    const [remappedValue, remappedPath] = onArrayFn(value, acc, key, updatedPath, source);
                    return reduceTree(remappedValue, acc, remappedPath);
                }
                return reduceTree(value, acc, updatedPath);
            }
            if (isPlainObject(value)) {
                if (onObjectFn) {
                    const [remappedValue, remappedPath] = onObjectFn(value, acc, key, updatedPath, source);
                    return reduceTree(remappedValue, acc, remappedPath);
                }
                return reduceTree(value, acc, updatedPath);
            }
            return onValueFn(value, acc, key, updatedPath, source);
        }, accumulator);
    };
    return reduceTree(cloneDeep(source), initial, [], true);
};
export function AllAndOnly() {
    // eslint-disable-next-line func-names
    return function (array) {
        return array;
    };
}
//# sourceMappingURL=type-utils.js.map