import { type Dict } from '@sage/xtrem-shared';
import type { PageNavigationPanel, PageProperties } from '../component/container/page/page-types';
import type { PageControlObject, TableProperties } from '../component/control-objects';
import { AbstractUiControlObject, SectionControlObject } from '../component/control-objects';
import type { PageDecoratorProperties, TableDecoratorProperties } from '../component/decorator-properties';
import * as xtremRedux from '../redux';
import type { NavigationPanelState, XtremAppState } from '../redux/state';
import type { CollectionValue } from '../service/collection-data-service';
import type { Page } from '../service/page';
import type { PageDefinition } from '../service/page-definition';
import type { ScreenBaseDefinition } from '../service/screen-base-definition';
import type { MakeRequired, ValueOrCallback } from './types';
import type { SidebarSectionDefinition } from '../component/table-sidebar/table-sidebar-types';
import type { FormattedNodeDetails } from '../service/metadata-types';
export declare const isScreenDefinitionDirty: (screenDefinition: ScreenBaseDefinition) => boolean;
export declare const hasAnyDirtyScreenDefinitions: (state: XtremAppState) => boolean;
export declare const getPageDefinitionFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageDefinition;
export declare const getPageDefinition: (screenId: string, state?: xtremRedux.XtremAppState) => PageDefinition | undefined;
export declare const getMainPageDefinitionFromState: (state?: xtremRedux.XtremAppState) => PageDefinition | undefined;
export declare const getPagePropertiesFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageProperties & PageDecoratorProperties<Page>;
export declare const getPageControlObjectFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageControlObject | null;
export declare const getPagePropertiesFromPageDefinition: (pageDefinition: PageDefinition) => PageProperties & PageDecoratorProperties<Page>;
export declare const getNavigationPanelState: (screenId: string, state?: xtremRedux.XtremAppState) => NavigationPanelState | null;
export declare const getNavigationPanelDefinitionFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageNavigationPanel<any> | null;
export declare const getNavigationPanelTablePropertiesFromPageDefinition: (pageDefinition: PageDefinition, isDefaultProps?: boolean) => TableDecoratorProperties;
export declare const checkIfPageIsLoaded: (screenId: string, state?: xtremRedux.XtremAppState) => void;
export declare function isFieldDataLoaded(pageDefinition: ScreenBaseDefinition, elementId: string): boolean;
export declare const arePlatformLiteralsMissing: (state?: xtremRedux.XtremAppState, locale?: string) => boolean;
export declare const getSidebarTableProperties: ({ elementId, pageDefinition, level, }: {
    pageDefinition: PageDefinition;
    level?: number;
    elementId: string;
}) => MakeRequired<TableProperties, "sidebar">;
export declare const getSidebarNormalFields: (layoutDefinition: Dict<SidebarSectionDefinition>) => AbstractUiControlObject[];
export declare const getSidebarNestedFields: (layoutDefinition: Dict<SidebarSectionDefinition>) => string[];
export declare function getResolvedSidebarLayout({ value, screenDefinition, level, nodeTypes, elementId, layout, }: {
    layout: ValueOrCallback<any, Dict<SidebarSectionDefinition>>;
    level?: number;
    value: CollectionValue;
    screenDefinition: ScreenBaseDefinition;
    elementId: string;
    nodeTypes: Dict<FormattedNodeDetails>;
}): Dict<SidebarSectionDefinition>;
export declare const isSidebarDirty: (state?: xtremRedux.XtremAppState) => boolean;
export declare const getVisibleSectionsFromPage: (screenId: string, screenDefinition?: ScreenBaseDefinition) => SectionControlObject[];
//# sourceMappingURL=state-utils.d.ts.map