import type { Dict } from '@sage/xtrem-shared';
import type { PropertyValueType } from '../component/field/reference/reference-types';
import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from '../service/metadata-types';
/**
 * Finds a node property type details from the list of known node types by doing an deep search in the graph structure.
 * @param targetNode
 * @param targetProperty
 * @param nodeTypes
 * @returns
 */
export declare const findDeepPropertyDetails: (targetNode?: string, targetProperty?: PropertyValueType, nodeTypes?: Dict<FormattedNodeDetails>, forFiltering?: boolean) => (FormattedNodeDetailsProperty & {
    parentNode: string;
}) | null;
/**
 * Finds a node property type from the list of known node types by doing an deep search in the graph structure
 * @param targetNode
 * @param targetProperty
 * @param nodeTypes
 * @param defaultValue optionally can be called with a defaultValue which is returned if no type definition is found
 * @returns
 */
export declare function findDeepPropertyType(targetNode: string | undefined, targetProperty: PropertyValueType | undefined, nodeTypes: Dict<FormattedNodeDetails>): FormattedNodeDetailsProperty | null;
export declare function findDeepPropertyType(targetNode: string | undefined, targetProperty: PropertyValueType | undefined, nodeTypes: Dict<FormattedNodeDetails>, forFiltering?: boolean): FormattedNodeDetailsProperty | null;
export declare const getDataTypeName: (node: string) => string;
//# sourceMappingURL=node-utils.d.ts.map