import { type Dict } from '@sage/xtrem-shared';
import type { UiComponentProperties } from '../component/abstract-ui-control-object';
import { SectionControlObject } from '../component/control-objects';
import type { ReadonlyFieldControlObject } from '../component/readonly-field-control-object';
import type { PageArticleItem, PageArticleLayout } from '../service/layout-types';
import type { AccessBindings, PageDefinition } from '../service/page-definition';
import type { ScreenBase } from '../service/screen-base';
import type { DialogDescription } from '../types/dialogs';
import type { NodePropertyType } from '../types';
import type { DataTypeDetails, FormattedNodeDetails } from '../service/metadata-types';
export declare const getFieldOrderAndFocusability: (screenId: string, articleItem: PageArticleLayout, uiComponentProperties: Dict<UiComponentProperties<ScreenBase>>, isParentFocusable: boolean, collector?: Dict<boolean>) => Dict<boolean>;
export declare const findNextField: (screenId: string, currentElementId?: string, isFocusable?: boolean) => ReadonlyFieldControlObject<any, any, any, any> | null;
export interface IsHiddenOrDisabledInLayoutArgs {
    componentProperties: Dict<UiComponentProperties>;
    screenId: string;
    elementId: string;
    accessBindings: AccessBindings;
    contextNode?: NodePropertyType;
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
}
export declare const isHiddenOrDisabledInLayout: ({ componentProperties, screenId, elementId, accessBindings, contextNode, nodeTypes, dataTypes, }: IsHiddenOrDisabledInLayoutArgs) => boolean;
export declare const isSectionUsedInAnyDialogs: (activeDialogs: Dict<DialogDescription>, sectionContainerId: string) => boolean;
export declare const getHeaderSection: (pageDefinition: PageDefinition, isSmallScreen?: boolean) => SectionControlObject | null;
export declare const getVisibleSections: (pageDefinition: PageDefinition, activeDialogs: Dict<DialogDescription>, isSmallScreen?: boolean) => Partial<PageArticleItem>[];
export declare const focusFirstElement: (selector: string, hasDialogActionButtons?: boolean) => void;
export declare function getLayoutChildren(item: Partial<PageArticleItem>, collector?: string[]): string[];
//# sourceMappingURL=layout-utils.d.ts.map