import { useRef } from 'react';
export const useTimer = () => {
    const timeout = useRef(null);
    /**
     * This function indicates whether or not a timer is currently running.
     */
    const isRunning = () => {
        return typeof timeout.current === 'number';
    };
    /**
     * This function aborts the currently running timer.
     */
    const abort = () => {
        if (timeout.current) {
            clearTimeout(timeout.current);
        }
    };
    /**
     * This function aborts the currently running timer (if applicable) and
     * starts/restarts a new timer with the given callback and delay.
     *
     * @param {function():void} callback
     * @param {number} delay
     */
    const start = (callback, delay) => {
        abort();
        timeout.current = window.setTimeout(callback, delay);
    };
    return { abort, isRunning, start };
};
//# sourceMappingURL=use-timer.js.map