import { usePrevious } from '@sage/xtrem-ui-components';
import { useEffect } from 'react';
export const useFocus = (componentRef, isInFocus = false, selector) => {
    const prevIsInFocus = usePrevious(isInFocus);
    useEffect(() => {
        if (!prevIsInFocus && isInFocus && componentRef.current) {
            const elementInFocus = document.activeElement;
            const element = selector ? getFocusableElement(componentRef.current, selector) : componentRef.current;
            if (element && elementInFocus !== element) {
                element.focus();
            }
        }
    });
};
const getFocusableElement = (fieldContainer, selector) => {
    return fieldContainer.querySelector(selector);
};
//# sourceMappingURL=use-focus.js.map