import type { CreateOperation, UpdateOperation } from '@sage/xtrem-client';
import type { CancelTokenSource } from 'axios';
import type { FileDepositValue } from '../component/types';
export declare const STATUS_CREATED = "created";
export declare const STATUS_UPLOADED = "uploaded";
export declare const STATUS_UPLOAD_FAILED = "uploadFailed";
export declare const STATUS_VERIFIED = "verified";
export declare const STATUS_CANCELLED = "cancelled";
export declare const STATUS_UPLOADING = "uploading";
export declare const STATUS_REJECTED = "rejected";
export declare function isDisallowedMimeType(allowedTypes: string | string[], fileType: string, fileName: string): boolean;
export interface FileDepositProgress {
    isInProgress: boolean;
    progress: number;
    fieldValue: Partial<FileDepositValue>;
    cancelTokenSource: CancelTokenSource;
}
export interface DepositFileArguments<K extends FileDepositValue['kind'] = FileDepositValue['kind']> {
    file: File;
    targetNodeMutations: {
        create: CreateOperation<any, any>;
        update: UpdateOperation<any, any>;
    };
    onUploadProgress?: (progressEvent: FileDepositProgress) => void;
    kind: K;
}
export declare function depositFile({ file, targetNodeMutations, onUploadProgress, kind, }: DepositFileArguments): Promise<FileDepositValue>;
export declare function showNotAllowedTypeToast(type: string): void;
export declare function getMimeTypeFromExtension(filename: string): string;
export declare const getMimeTypeUserFriendlyName: (mimeType: string) => string;
//# sourceMappingURL=file-deposit-utils.d.ts.map