import { type Dict } from '@sage/xtrem-shared';
import type { HasGenericErrorHandler, VoidPromise } from '../component/field/traits';
import type { NestedFieldsProperties } from '../component/nested-fields';
import type { Events } from '../component/types';
export type NestedFieldComponentProperties = NestedFieldsProperties<any> & HasGenericErrorHandler<any>;
type HandledEventContainer = {
    onClick: Function;
    onError?: Function;
    onClickAfter?: Array<Function>;
    delegateErrorToCaller?: boolean;
} | {
    onChange: Function;
    onError?: Function;
    delegateErrorToCaller?: boolean;
};
export declare const executeEventHandlerWithExternalHandler: ({ screenId, elementId, args, eventHandler, }: {
    eventHandler: () => VoidPromise;
    screenId: string;
    elementId: string;
    args: any[];
}) => Promise<void>;
type ForScreen<Rest extends unknown[]> = (screenId: string, ...args: Rest) => Promise<void>;
type ForField<Rest extends unknown[]> = (screenId: string, elementId: string, ...args: Rest) => Promise<void>;
type ForNestedField<Rest extends unknown[]> = (screenId: string, elementId: string, nestedDef: NestedFieldComponentProperties, ...args: Rest) => Promise<void>;
type TriggerEventForScreen = ForScreen<[eventName: Extract<Events, 'onLoad' | 'onOpen'>] | [eventName: Extract<Events, 'onClose'>, isWizardFinished?: boolean] | [eventName: Extract<Events, 'onDirtyStateUpdated' | 'on360ViewSwitched'>, state: boolean]>;
type TriggerEventForField = ForField<[eventName: Extract<Events, 'onActive' | 'onInactive' | 'onAllDataLoaded' | 'onDataLoaded'>] | [eventName: Extract<Events, 'onChange'>] | [eventName: Extract<Events, 'onClick'>] | [eventName: Extract<Events, 'onReady'>] | [eventName: Extract<Events, 'onHeaderValueChanged' | 'onFooterValueChanged'>, newValue?: string] | [eventName: Extract<Events, 'onEmptyStateLinkClick'>] | [eventName: Extract<Events, 'onEmptyStateLinkClick'>, parentId?: string, level?: number] | [eventName: Extract<Events, 'onClick'>, rowId: string, rowData: Dict<any>, level?: number, ancestorIds?: string[]] | [
    eventName: Extract<Events, 'onChange' | 'onRecordAdded' | 'onRecordClick' | 'onRecordRemoved' | 'onRowAdded' | 'onRowActivated' | 'onRowClick' | 'onRowDeactivated' | 'onRowSelected' | 'onRowUnselected'>,
    rowId: string,
    rowData: Dict<any>,
    level?: number,
    ancestorIds?: string[]
] | [eventName: Extract<Events, 'onRecordClick'>, rowData: Dict<any>] | [
    eventName: Extract<Events, 'onEventClick'>,
    eventId: string,
    event: Dict<any> | null,
    isModifierKeyPushed: boolean
] | [eventName: Extract<Events, 'onDayClick'>, date: Date] | [eventName: Extract<Events, 'onInputValueChange'>, inputValue: string] | [eventName: Extract<Events, 'onFileInfo'>, mimetype: string, length: number, fileName: string] | [eventName: Extract<Events, 'onCloseLookupDialog' | 'onOpenLookupDialog'>]>;
type TriggerEventForNestedField = ForNestedField<[eventName: Extract<Events, 'onClick'>, rowId: string, rowData: Dict<any>, level?: number, ancestorIds?: string[]] | [eventName: Extract<Events, 'onLevelExpanded'>, parentId: string, children: Dict<any>[]] | [
    eventName: Extract<Events, 'onChange'>,
    columnId: string,
    rowData: Dict<any>,
    level?: number,
    ancestorIds?: string[]
]>;
type ForHandledEventContainer<Rest extends unknown[]> = (screenId: string, elementId: string, handledEventContainer: HandledEventContainer, ...args: Rest) => Promise<void>;
type TriggerHandledEvent = ForHandledEventContainer<[
] | [rowId: string, rowData: Dict<any>] | [rowId: string, rowData: Dict<any>, level: number, ancestorIds: string[]]>;
export declare const triggerScreenEvent: TriggerEventForScreen;
export declare const triggerFieldEvent: TriggerEventForField;
export declare const triggerNestedFieldEvent: TriggerEventForNestedField;
export declare const triggerHandledEvent: TriggerHandledEvent;
export declare const isBulkChange: (s1: string, s2: string) => boolean;
export declare const executeCallbackInScreenContext: (callback: Function, screenId: string, ...args: any[]) => void;
export {};
//# sourceMappingURL=events.d.ts.map