import type { PageDefinition } from '../service/page-definition';
import type { PageMetadata } from '../service/page-metadata';
/**
 * Replaces the page's business actions with the duplicate actions
 * It mutates the pageDefinition object
 * */
export declare function applyDuplicationBusinessActions(pageDefinition: PageDefinition): void;
/**
 * Replaces the page's layout with a single section that contains only the fields which are required for duplication
 * It mutates the pageDefinition object
 * */
export declare function applyDuplicationLayoutStructure(pageDefinition: PageDefinition): void;
/**
 * Add a section and a block control object to the page definition
 * @param pageMetadata
 * @returns
 */
export declare function addDuplicationLayoutContainers(pageMetadata: PageMetadata): void;
//# sourceMappingURL=duplication-utils.d.ts.map