import type { ClientNode, Dict } from '@sage/xtrem-client';
import type { AbstractFieldDecorator } from '../component/abstract-field-decorator';
import type { ComponentKey, DecoratorTarget, FieldKey, MetadataProps } from '../component/types';
import { DecoratorProperties } from '../component/types';
import type { Extend } from '../service/page-extension';
import type { ScreenExtension } from '../types';
import type { DataTypeDetails, FormattedNodeDetails } from '../service/metadata-types';
import type { VoidPromise } from '../component/field/traits';
export type OverrideDecoratorProperties<DecoratorProperties> = Partial<Omit<DecoratorProperties, 'aggregateOn' | 'aggregationMethod' | 'bind' | 'boundTo' | 'chart' | 'columns' | 'endDateField' | 'eventCard' | 'fields' | 'helperTextField' | 'insertAfter' | 'insertBefore' | 'isTransient' | 'levels' | 'mobileCard' | 'node' | 'optionType' | 'parent' | 'pluginPackage' | 'startDateField' | 'valueField'>>;
export type OverrideNestedDecoratorProperties<DecoratorProperties> = Partial<Omit<DecoratorProperties, 'aggregateOn' | 'aggregationMethod' | 'chart' | 'columns' | 'endDateField' | 'eventCard' | 'fields' | 'helperTextField' | 'insertAfter' | 'insertBefore' | 'isTransient' | 'levels' | 'mobileCard' | 'node' | 'optionType' | 'parent' | 'pluginPackage' | 'startDateField'>>;
export type ClickableOverrideDecoratorProperties<DecoratorProperties, CT> = {
    onClickAfter?: (this: CT) => VoidPromise;
} & OverrideDecoratorProperties<DecoratorProperties>;
export type ChangeableOverrideDecoratorProperties<DecoratorProperties, CT> = {
    onChangeAfter?: (this: CT) => VoidPromise;
} & ClickableOverrideDecoratorProperties<Omit<DecoratorProperties, '_controlObjectType'>, CT>;
export type ClickableNestedOverrideDecoratorProperties<DecoratorProperties, CT, C extends ClientNode = any> = {
    onClickAfter?: (this: CT, id: string, rowValue: C) => VoidPromise;
} & OverrideDecoratorProperties<DecoratorProperties>;
export type ChangeableNestedOverrideDecoratorProperties<DecoratorProperties, CT, C extends ClientNode = any> = {
    onChangeAfter?: (this: CT, id: string, rowValue: C) => VoidPromise;
} & ClickableOverrideDecoratorProperties<DecoratorProperties, CT>;
/**
 * Checks if the constructor passed in is a page or an extension. If an extension, it returns the page constructor
 * that is being extended. For more information, see the screen-loader-service's evaluateJavascriptResponse method
 * @param constructor
 */
export declare const getTargetPrototype: (constructor: Function) => Function;
/**
 * Standard decorator implementation. It implements the basic builder behavior which can be used by most of the fields
 * and containers.
 *
 * It creates a thunk function and appends it to the `pageMetadata` object so it can be executed once all information
 * is gathered from ALL decorator properties. See the screen loader service for further details.
 */
export declare function standardDecoratorImplementation<T extends ScreenExtension<T>, D extends FieldKey, N extends ClientNode = any>(properties: DecoratorProperties<D, Extend<T>, N>, decoratorClass: new (target: DecoratorTarget<T>, name: string, componentType: D, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, metadataProps: MetadataProps<D>) => AbstractFieldDecorator<D>, componentType: D, checkForNode?: boolean): (target: T, name: string) => void;
/**
 * Standard extension decorator implementation.
 *
 */
export declare function standardExtensionDecoratorImplementation<CT extends ScreenExtension<CT>, D extends ComponentKey, N extends ClientNode = any>(properties: OverrideDecoratorProperties<DecoratorProperties<D, Extend<CT>, N>>): (target: CT, name: string) => void;
//# sourceMappingURL=decorator-utils.d.ts.map