import { CalendarDate } from '@internationalized/date';
import { DateValue, Datetime, date, formatDateToCurrentLocale, formatTimeToLocale } from '@sage/xtrem-date-time';
// Date part type constants
export const DATE_PART_YEAR = 'year';
export const DATE_PART_MONTH = 'month';
export const DATE_PART_DAY = 'day';
export function isRowValueInDateGroup(rowValue, groupValue, aggFunc) {
    const dateValue = date.parse(rowValue);
    const groupDate = date.parse(groupValue);
    const isSameYear = () => dateValue.year === groupDate.year;
    const isSameMonth = () => dateValue.month === groupDate.month;
    const isSameDay = () => dateValue.day === groupDate.day;
    if (aggFunc === DATE_PART_YEAR) {
        return isSameYear();
    }
    if (aggFunc === DATE_PART_MONTH) {
        return isSameYear() && isSameMonth();
    }
    if (aggFunc === DATE_PART_DAY) {
        return isSameYear() && isSameMonth() && isSameDay();
    }
    return false;
}
export function getTimezoneUtcOffsetByCity(timeZone) {
    const formatter = new Intl.DateTimeFormat([], { timeZoneName: 'longOffset', timeZone });
    const dummyDate = formatter.format(new Date());
    const parts = dummyDate.split(', GMT');
    return `GMT${parts[1] || ''}`;
}
export function datePropertyValueToCalendarDate(value) {
    if (!value)
        return undefined;
    if (value instanceof CalendarDate)
        return value;
    if (DateValue.isDate(value)) {
        return new CalendarDate(value.year, value.month, value.day);
    }
    if (value instanceof Date) {
        return new CalendarDate(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }
    if (typeof value === 'string') {
        try {
            const dateValue = DateValue.parse(value);
            return new CalendarDate(dateValue.year, dateValue.month, dateValue.day);
        }
        catch {
            const date = new Date(value);
            if (!Number.isNaN(date.getTime())) {
                return new CalendarDate(date.getFullYear(), date.getMonth() + 1, date.getDate());
            }
            return undefined;
        }
    }
    return undefined;
}
export function getDateTimeString(locale, dateString) {
    if (!dateString) {
        return null;
    }
    const datetime = Datetime.parse(dateString);
    const time = formatTimeToLocale(datetime.time, locale);
    if (datetime.date.equals(date.today())) {
        return time;
    }
    return `${formatDateToCurrentLocale(datetime.date, locale)} ${time}`;
}
//# sourceMappingURL=date-utils.js.map