import { arSA } from 'date-fns/locale/ar-SA';
import { de } from 'date-fns/locale/de';
import { enGB } from 'date-fns/locale/en-GB';
import { enUS } from 'date-fns/locale/en-US';
import { es } from 'date-fns/locale/es';
import { fr } from 'date-fns/locale/fr';
import { it } from 'date-fns/locale/it';
import { pl } from 'date-fns/locale/pl';
import { pt } from 'date-fns/locale/pt';
import { ptBR } from 'date-fns/locale/pt-BR';
import { zhCN } from 'date-fns/locale/zh-CN';
import { memoize } from 'lodash';
import { localize } from '../service/i18n-service';
const dateLocales = {
    'en-GB': enGB,
    'en-US': enUS,
    'es-ES': es,
    'pl-PL': pl,
    'zh-CN': zhCN,
    'fr-FR': fr,
    'pt-PT': pt,
    'pt-BR': ptBR,
    'ar-SA': arSA,
    'de-DE': de,
    'it-IT': it,
};
export const isSingular = (count) => parseInt(count, 10) === 1;
export const carbonLocale = memoize((selectedLocale) => ({
    locale: () => selectedLocale,
    actions: {
        edit: () => localize('@sage/xtrem-ui/action-edit', 'Edit'),
        delete: () => localize('@sage/xtrem-ui/action-delete', 'Delete'),
    },
    actionPopover: {
        ariaLabel: () => 'actions',
    },
    batchSelection: {
        selected: (count) => localize('@sage/xtrem-ui/action-tool-bar-items-selected', 'Items selected: {{count}}', { count }),
    },
    confirm: {
        no: () => localize('@sage/xtrem-ui/generic-no', 'No'),
        yes: () => localize('@sage/xtrem-ui/generic-yes', 'Yes'),
    },
    date: {
        dateFnsLocale: () => dateLocales[selectedLocale] || dateLocales['en-US'],
        ariaLabels: {
            previousMonthButton: () => localize('@sage/xtrem-ui/previous-month', 'Previous month'),
            nextMonthButton: () => localize('@sage/xtrem-ui/next-month', 'Next month'),
        },
        dateFormatOverride: localize('@sage/xtrem-ui/carbon-date-format', 'MM/dd/yyyy'),
    },
    errors: {
        messages: {
            formSummary: () => null,
        },
    },
    message: {
        ai: () => localize('@sage/xtrem-ui/message-type-ai', 'AI'),
        error: () => localize('@sage/xtrem-ui/message-type-error', 'Error'),
        info: () => localize('@sage/xtrem-ui/message-type-info', 'Information'),
        success: () => localize('@sage/xtrem-ui/message-type-success', 'Success'),
        warning: () => localize('@sage/xtrem-ui/message-type-warning', 'Warning'),
        neutral: () => localize('@sage/xtrem-ui/message-type-information', 'Information'),
        closeButtonAriaLabel: () => localize('@sage/xtrem-ui/action-close', 'Close'),
    },
    numeralDate: {
        validation: {
            day: () => localize('@sage/xtrem-ui/date-error-day-range', 'Day should be a number within a 1-31 range.'),
            month: () => localize('@sage/xtrem-ui/date-error-month-range', 'Month should be a number within a 1-12 range.'),
            year: () => localize('@sage/xtrem-ui/date-error-year-range', 'Year should be a number within a 1800-2200 range.'),
        },
        labels: {
            day: () => localize('@sage/xtrem-ui/calendar-view-day', 'Day'),
            month: () => localize('@sage/xtrem-ui/calendar-view-month', 'Month'),
            year: () => localize('@sage/xtrem-ui/calendar-view-year', 'Year'),
        },
    },
    pager: {
        show: () => localize('@sage/xtrem-ui/table-show', 'Show'),
        records: (count, showNumber = true) => {
            const noun = isSingular(count) ? 'item' : 'items';
            return showNumber ? `${count} ${noun}` : noun;
        },
        first: () => localize('@sage/xtrem-ui/table-first', 'First'),
        last: () => localize('@sage/xtrem-ui/table-last', 'Last'),
        next: () => localize('@sage/xtrem-ui/table-next', 'Next'),
        previous: () => localize('@sage/xtrem-ui/table-previous', 'Previous'),
        pageX: () => 'Page',
        ofY: (count) => `of ${count}`,
    },
    select: {
        actionButtonText: () => 'Add an item',
        placeholder: () => localize('@sage/xtrem-ui/please-select-placeholder', 'Please Select...'),
        noResultsForTerm: (term) => `No results for "${term}"`,
    },
    switch: {
        on: () => localize('@sage/xtrem-ui/switch-on-caps', 'ON'),
        off: () => localize('@sage/xtrem-ui/switch-off-caps', 'OFF'),
    },
    textEditor: {
        boldAria: () => localize('@sage/xtrem-ui/text-format-capital-bold', 'Bold'),
        italicAria: () => localize('@sage/xtrem-ui/text-format-capital-italic', 'Italic'),
        unorderedListAria: () => localize('@sage/xtrem-ui/text-format-capital-bullet-list', 'Bullet List'),
        orderedListAria: () => localize('@sage/xtrem-ui/text-format-capital-number-list', 'Number List'),
        cancelButton: () => localize('@sage/xtrem-ui/text-editor-cancel', 'Cancel'),
        cancelButtonAria: () => localize('@sage/xtrem-ui/text-editor-cancel-button', 'Cancel'),
        characterCounter: () => localize('@sage/xtrem-ui/text-editor-character-counter', 'Character count'),
        characterLimit: () => localize('@sage/xtrem-ui/text-editor-character-limit', 'Character limit'),
        contentEditorAria: () => localize('@sage/xtrem-ui/text-editor-content-editor', 'Content editor'),
        saveButton: () => localize('@sage/xtrem-ui/text-editor-save', 'Save'),
        saveButtonAria: () => localize('@sage/xtrem-ui/text-editor-save-button', 'Save'),
        toolbarAriaLabel: () => localize('@sage/xtrem-ui/text-editor-toolbar', 'Toolbar'),
    },
}));
export function clearCarbonLocaleCache() {
    carbonLocale.cache?.clear?.();
}
//# sourceMappingURL=carbon-locale.js.map