import { section } from '../component/container/section/section-decorator';
import { multiFileDepositField } from '../component/field/multi-file-deposit/multi-file-deposit-decorator';
import { attachmentsMimeTypes, attachmentsMimeTypesByExtention } from '@sage/xtrem-shared';
import { schemaTypeNameFromNodeName } from './transformers';
import { findDeepPropertyType } from './node-utils';
import { ATTACHMENT_SECTION_ID, ATTACHMENTS_ELEMENT_ID, ATTACHMENTS_PROPERTY_NAME } from './constants';
import { localize } from '../service/i18n-service';
const TWENTY_PLUS = '20+';
const documentMimeTypes = [
    ...attachmentsMimeTypesByExtention.pdf,
    ...attachmentsMimeTypesByExtention.pptx,
    ...attachmentsMimeTypesByExtention.docx,
    ...attachmentsMimeTypesByExtention.xlsx,
];
const imageMimeTypes = [
    ...attachmentsMimeTypesByExtention.bmp,
    ...attachmentsMimeTypesByExtention.gif,
    ...attachmentsMimeTypesByExtention.heic,
    ...attachmentsMimeTypesByExtention.heif,
    ...attachmentsMimeTypesByExtention.jfif,
    ...attachmentsMimeTypesByExtention.jpeg,
    ...attachmentsMimeTypesByExtention.jpg,
    ...attachmentsMimeTypesByExtention.png,
    ...attachmentsMimeTypesByExtention.svg,
    ...attachmentsMimeTypesByExtention.tif,
    ...attachmentsMimeTypesByExtention.tiff,
];
export const getAttachmentInformation = (nodeName, nodeTypes) => {
    const node = schemaTypeNameFromNodeName(nodeName);
    if (!nodeTypes[node]?.hasAttachments) {
        return null;
    }
    const attachmentAssociationNode = findDeepPropertyType(node, ATTACHMENTS_PROPERTY_NAME, nodeTypes)?.targetNode;
    const attachmentFileNode = findDeepPropertyType(node, `${ATTACHMENTS_PROPERTY_NAME}.attachment`, nodeTypes)?.targetNode;
    if (attachmentAssociationNode && attachmentFileNode) {
        return {
            attachmentAssociationNode,
            attachmentFileNode,
        };
    }
    return null;
};
export function getAttachmentCount(values) {
    if (values[ATTACHMENTS_ELEMENT_ID]?.pageInfo && values[ATTACHMENTS_ELEMENT_ID]?.data) {
        return values[ATTACHMENTS_ELEMENT_ID].pageInfo?.hasNextPage
            ? TWENTY_PLUS
            : String(values[ATTACHMENTS_ELEMENT_ID].data.length);
    }
    return undefined;
}
export function setAttachmentCountOnMetadata(pageMetadata, values) {
    pageMetadata.uiComponentProperties[ATTACHMENT_SECTION_ID].indicatorContent =
        getAttachmentCount(values);
}
export function addAttachmentElements(pageMetadata, attachmentInformation) {
    if (!pageMetadata?.target) {
        return;
    }
    section({
        title: localize('@sage/xtrem-ui/attachments', 'Attachments'),
    })(pageMetadata.target, ATTACHMENT_SECTION_ID);
    multiFileDepositField({
        parent() {
            return this[ATTACHMENT_SECTION_ID];
        },
        isTitleHidden: true,
        bind: ATTACHMENTS_PROPERTY_NAME,
        title: localize('@sage/xtrem-ui/attachments', 'Attachments'),
        node: attachmentInformation.attachmentAssociationNode,
        attachmentNode: attachmentInformation.attachmentFileNode,
        canUserHideColumns: true,
        fileTypes: attachmentsMimeTypes.join(', '),
        kind: 'attachment',
        optionsMenu: [
            {
                id: 'all',
                title: localize('@sage/xtrem-ui/attachment-options-menu-all', 'All file types'),
                graphQLFilter: {},
            },
            {
                id: 'documents',
                title: localize('@sage/xtrem-ui/attachment-options-menu-documents', 'Documents'),
                graphQLFilter: { attachment: { mimeType: { _in: documentMimeTypes } } },
            },
            {
                id: 'images',
                title: localize('@sage/xtrem-ui/attachment-options-menu-images', 'Images'),
                graphQLFilter: { attachment: { mimeType: { _in: imageMimeTypes } } },
            },
            {
                id: 'others',
                title: localize('@sage/xtrem-ui/attachment-options-menu-others', 'Others'),
                graphQLFilter: { attachment: { mimeType: { _nin: [...imageMimeTypes, ...documentMimeTypes] } } },
            },
        ],
        onChange() {
            const totalCount = this[ATTACHMENTS_ELEMENT_ID].value.length;
            this[ATTACHMENT_SECTION_ID].indicatorContent = totalCount > 20 ? TWENTY_PLUS : String(totalCount);
        },
        isFullWidth: true,
    })(pageMetadata.target, ATTACHMENTS_ELEMENT_ID);
}
//# sourceMappingURL=attachment-utils.js.map