import type { PageMetadata } from '../service/page-metadata';
import type { AttachmentInformation } from '../service/node-information-service';
import type { Page } from '../service/page';
import type { MultiFileDepositControlObject, SectionControlObject } from '../component/control-objects';
import { type Dict } from '@sage/xtrem-shared';
import type { FormattedNodeDetails } from '../service/metadata-types';
import { ATTACHMENT_SECTION_ID, ATTACHMENTS_ELEMENT_ID } from './constants';
import type { ScreenBaseDefinition } from '../service/screen-base-definition';
export declare const getAttachmentInformation: (nodeName: string, nodeTypes: Dict<FormattedNodeDetails>) => AttachmentInformation | null;
export interface PageWithAttachmentElements extends Page {
    [ATTACHMENT_SECTION_ID]: SectionControlObject;
    [ATTACHMENTS_ELEMENT_ID]: MultiFileDepositControlObject;
}
export declare function getAttachmentCount(values: ScreenBaseDefinition['values']): string | undefined;
export declare function setAttachmentCountOnMetadata(pageMetadata: PageMetadata, values: ScreenBaseDefinition['values']): void;
export declare function addAttachmentElements(pageMetadata: PageMetadata, attachmentInformation: AttachmentInformation): void;
//# sourceMappingURL=attachment-utils.d.ts.map