import * as idb from 'idb';
import type { GraphqlCacheSettings } from '../service/graphql-utils';
import type { RawNodeDetails } from '../service/metadata-types';
import type { InstalledPackageList } from '../service/metadata-service';
export interface ArtifactCacheEntry {
    key: string;
    version: string;
    locale: string;
    shouldFetchPlatformLiterals: string;
    /** Encrypted cache data */
    data: any;
    /** Cached timestamp */
    cachedAt: number;
}
export declare function getArtifactCacheDatabase(): Promise<idb.IDBPDatabase>;
export declare function getArtifactCachedEntry({ db, cacheSettings, passphrase, }: {
    db: idb.IDBPDatabase;
    cacheSettings: GraphqlCacheSettings;
    passphrase?: string;
}): Promise<any | null>;
export declare function cacheArtifact({ db, cacheSettings, data, passphrase, }: {
    db: idb.IDBPDatabase;
    cacheSettings: GraphqlCacheSettings;
    data: any;
    passphrase?: string;
}): Promise<void>;
export declare function getCachedRawNodeDetails({ db, installedPackages, passphrase, }: {
    db: idb.IDBPDatabase;
    installedPackages: InstalledPackageList;
    passphrase?: string;
}): Promise<RawNodeDetails[]>;
/**
 * Clear out of date entries from the cache
 */
export declare function clearOutOfDateEntries({ db, installedPackages, }: {
    db: idb.IDBPDatabase;
    installedPackages: InstalledPackageList;
}): Promise<void>;
//# sourceMappingURL=artifact-cache-utils.d.ts.map