import type { ColumnState, DateFilterModel, GridApi, NumberFilterModel, SetFilterModel, TextFilterModel } from '@ag-grid-community/core';
import { type Dict } from '@sage/xtrem-shared';
import type { EnumType } from 'json-to-graphql-query';
import type { PickProperties } from 'ts-essentials';
import type { CollectionValue } from '../../service/collection-data-service';
import type { Filter } from '../../service/filter-service';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { AgGridColumnConfigWithScreenIdAndColDef, ColumnPanelColumnState, FilterValue } from './ag-grid-utility-types';
import type { OptionsMenuItem, TableProperties } from '../../component/control-objects';
import { type TableDecoratorProperties } from '../../component/field/table/table-component-types';
import type { NodePropertyType } from '../../types';
export type FilterModel = DateFilterModel | NumberFilterModel | TextFilterModel | SetFilterModel;
export declare const ROW_HEIGHT = 40;
export declare const GROUP_ROW_HEIGHT: number;
export declare const getFilterValueFromAgGridFilterStatement: (filterBase: FilterModel & {
    filterById?: boolean;
}, filterKey: string) => FilterValue;
export declare function callGridMethod<M extends keyof PickProperties<GridApi, (...args: any[]) => any>>(gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): ReturnType<GridApi[M]> | undefined;
export declare function getSafeGridApiContext<M extends keyof PickProperties<GridApi, (...args: any[]) => any>, R>(cb: (arg: ReturnType<GridApi[M]> extends void ? undefined : ReturnType<GridApi[M]>) => R, gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): R | undefined;
export type FilterTypes = string | number | boolean | EnumType;
type ArgsType<T> = T extends (...args: infer A) => any ? A : never;
export declare const mapAgGridFilterToXtremFilters: (filterModel: Dict<any>) => (filterKey: any) => Filter<FilterTypes>;
export declare const tryToCommitPhantomRow: ({ api, screenId, value, elementId, }: {
    api: GridApi;
    screenId: string;
    value: CollectionValue;
    elementId: string;
}) => Promise<Dict<ValidationResult> | null>;
export declare const getFirstEditableColumn: (api: GridApi, data?: any, includeSelect?: boolean) => string | undefined;
export declare const getFilterModel: (api?: GridApi | null, groupByColumnField?: string) => any | undefined;
export declare function getSelectionFilter({ groupByColumn, gridApi, screenId, isSelectAllChecked, tableFieldProperties, activeOptionsMenuItem, mode, }: {
    groupByColumn?: AgGridColumnConfigWithScreenIdAndColDef;
    gridApi: GridApi;
    screenId: string;
    isSelectAllChecked: boolean;
    tableFieldProperties: TableProperties;
    activeOptionsMenuItem?: OptionsMenuItem;
    mode?: 'server' | 'client';
}): any;
export declare const getAllUnselectedIds: (gridApi: GridApi) => string[];
export declare const getColumnStatesForColumnPanel: (screenId: string, columnDefinitions?: AgGridColumnConfigWithScreenIdAndColDef[], columnStates?: ColumnState[]) => ColumnPanelColumnState[];
export declare function pasteToSelectedCell(api: GridApi): Promise<void>;
export declare function copySelectedCellValue(cellValue: string): Promise<void>;
export declare const getTotalRecordCount: ({ api, fieldProperties, activeOptionsMenuItem, screenId, node, groupByColumnField, }: {
    api: GridApi;
    fieldProperties: TableDecoratorProperties;
    activeOptionsMenuItem?: OptionsMenuItem;
    screenId: string;
    node: NodePropertyType;
    groupByColumnField?: string;
}) => Promise<number>;
export {};
//# sourceMappingURL=ag-grid-table-utils.d.ts.map