import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import { FieldKey } from '@sage/xtrem-shared';
import type { ColumnsData, InternalTableProperties, TableViewLevel, TableViewSortedColumn } from '../../component/field/table/table-component-types';
import type { NestedField, NestedFieldTypes } from '../../component/nested-fields';
import type { CollectionValue } from '../../service/collection-data-service';
import type { DataTypeDetails, FormattedNodeDetails } from '../../service/metadata-types';
import type { AccessBindings } from '../../service/page-definition';
import type { ScreenBase } from '../../service/screen-base';
import type { NodePropertyType } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../types';
import type { AgGridColumnConfigWithScreenIdAndColDef } from './ag-grid-utility-types';
export declare const shouldDisplayColumnInPanel: ((columnDefinition?: NestedField<ScreenBase, any>) => boolean) & import("lodash").MemoizedFunction;
export declare function isColumnAvailable({ screenId, columnDefinition, nodeTypes, dataTypes, contextNode, accessBindings, }: {
    screenId: string;
    columnDefinition: NestedField<ScreenBase, Exclude<NestedFieldTypes, FieldKey.Technical>, any>;
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
    contextNode: string;
    accessBindings: AccessBindings;
}): boolean;
export declare const getCellClass: (isEditable: boolean, columnId: string, columnDefinition: NestedField<ScreenBase, NestedFieldTypes>, title: string, columnDefinitionType: NestedFieldTypes) => string[];
export declare function withoutNestedTechnicalColumns(argument: ColumnsData[]): ColumnsData<Exclude<NestedFieldTypes, FieldKey.Technical>>[];
export declare const getColumns: ({ accessBindings, columnsData, dataTypes, currentTableView, elementId: tableElementId, enumTypes, fieldProperties, isDisabled, isFilteringDisabled, groupBy, hasFloatingFilters, isParentDisabled, isReadOnly, level, locale, lookupSelectionMode, nodeTypes, pageNode, screenId, isSortingDisabled, value, }: {
    accessBindings: AccessBindings;
    columnsData: ColumnsData[];
    currentTableView?: TableViewLevel;
    elementId: string;
    enumTypes: Dict<string[]>;
    /**
     * Ag-grid seems to cache some of these values in the column configuration, so in order to ensure that we always
     * have an up-to-date version of the properties, we pass them in as a callback
     * */
    fieldProperties: () => Omit<InternalTableProperties, "selectedRecords">;
    isDisabled?: boolean;
    isFilteringDisabled?: boolean;
    groupBy?: string;
    hasFloatingFilters?: boolean;
    level: number;
    locale: LocalizeLocale;
    lookupSelectionMode?: "single" | "multiple";
    isParentDisabled: () => boolean;
    isReadOnly?: ValueOrCallbackWithFieldValue<ScreenBase, boolean>;
    nodeTypes: Dict<FormattedNodeDetails>;
    pageNode?: NodePropertyType;
    screenId: string;
    isSortingDisabled?: boolean;
    customizedOrderBy?: TableViewSortedColumn[];
    dataTypes: Dict<DataTypeDetails>;
    /**
     * Ag-grid seems to cache some of these values in the column configuration, so in order to ensure that we always
     * have an up-to-date version of the value, we pass them in as a callback
     * */
    value: () => CollectionValue;
}) => AgGridColumnConfigWithScreenIdAndColDef[];
//# sourceMappingURL=ag-grid-service.d.ts.map