import type { ColDef, Column, ICellRendererParams, RowNode, SelectionColumnDef, ValueFormatterParams, ValueGetterParams, ValueSetterParams } from '@ag-grid-community/core';
import { type Dict, type LocalizeLocale } from '@sage/xtrem-shared';
import type { MarkRequired } from 'ts-essentials';
import type { NestedCheckboxProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLinkProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties } from '../../component/decorators';
import type { NestedCountProperties } from '../../component/field/count/count-types';
import type { NestedDatetimeRangeProperties } from '../../component/field/datetime-range/datetime-range-types';
import type { InternalNestedGridProperties } from '../../component/field/field-control-objects';
import type { NestedLabelProperties } from '../../component/field/label/label-decorator';
import type { NestedNumericProperties } from '../../component/field/numeric/numeric-types';
import type { InternalTableProperties } from '../../component/field/table/table-component-types';
import type { NestedTextProperties } from '../../component/field/text/text-types';
import type { Nested } from '../../component/field/traits';
import type { NestedField, NestedFieldTypesWithoutTechnical, NestedFieldsProperties } from '../../component/nested-fields';
import type { GridRowActionOrMenuSeparatorType, GridRowActionType } from '../../component/types';
import type { CellWrapperProps } from '../../component/ui/table-shared/cell/cell-wrapper';
import type { CollectionValue } from '../../service/collection-data-service';
import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from '../../service/metadata-types';
import type { AccessBindings } from '../../service/page-definition';
import type { ScreenBase } from '../../service/screen-base';
import type { ScreenBaseGenericType } from '../../types';
import { ContextType } from '../../types';
import type { Merge, SetRequired, ValueOrCallbackWithFieldValue } from '../types';
import type { AgGridColumnConfigWithAllColumns, AgGridColumnConfigWithScreenIdAndColDef } from './ag-grid-utility-types';
interface CellEditorProps extends Omit<ICellRendererParams, 'value'> {
    eventKey: string | null;
    initialValue: any;
    onValueChange: (value: any) => void;
    stopEditing: (suppressNavigateAfterEdit?: boolean) => void;
    value: string;
}
export interface CellParams<T extends Nested<any> = Nested, V = string> extends Omit<CellEditorProps, 'colDef' | 'value'>, CellProps<T> {
    colDef: MarkRequired<Omit<AgGridColumnConfigWithScreenIdAndColDef, 'cellRendererParams'>, 'field'> & {
        cellRendererParams: CellProps<T>;
    };
    value: V;
    node: RowNode;
    column: Column;
}
export interface CellProps<T> {
    columnId: string;
    contextNode?: keyof ScreenBaseGenericType<ScreenBase>;
    elementId: string;
    fieldProperties: WithNestedWrapper<T>;
    isEditing?: boolean;
    isParentFieldDisabled: boolean;
    isTableReadOnly?: ValueOrCallbackWithFieldValue<ScreenBase, boolean>;
    isTree: boolean;
    locale: LocalizeLocale;
    screenId: string;
    tableElementId: string;
    collectionValue: () => CollectionValue;
}
type ICellParams<T extends Nested<any>> = CellProps<T> | ((p: any) => CellProps<T>);
type ColumnProps<T extends Nested<any>> = Merge<SetRequired<ColDef, 'cellRenderer'>, {
    cellRendererParams: ICellParams<T>;
    cellEditorParams?: ICellParams<T>;
}>;
export interface ColumnConfigurationProperties<T extends Nested<any>> {
    collectionValue: () => CollectionValue;
    columnId: string;
    columnProperties: T;
    enumTypes: Dict<string[]>;
    hasFloatingFilters: boolean;
    isParentFieldDisabled: boolean;
    isReadOnly: ValueOrCallbackWithFieldValue<ScreenBase, boolean> | undefined;
    level: number;
    locale: LocalizeLocale;
    nodeTypes: Dict<FormattedNodeDetails>;
    propertyGraphType: FormattedNodeDetailsProperty | null;
    screenId: string;
    tableElementId: string;
    tableProperties: InternalTableProperties<ScreenBase> | InternalNestedGridProperties<ScreenBase>;
}
export type NestedProperties = NestedReferenceProperties | NestedLabelProperties | NestedCheckboxProperties | NestedDateProperties | NestedTextProperties | NestedProgressProperties | NestedNumericProperties | NestedFilterSelectProperties | NestedDropdownListProperties | NestedSelectProperties | NestedSwitchProperties;
export declare const defaultValueGetter: (params: Pick<ValueGetterParams, "colDef" | "data">, screenId: string, columnProperties: NestedFieldsProperties<NestedFieldTypesWithoutTechnical, ScreenBase>) => (mapper?: (value: any) => any) => any;
export declare const defaultValueSetter: (params: ValueSetterParams, stringToValueConverter?: (value: string) => any) => boolean;
export declare const getReferenceFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedReferenceProperties>) => ColumnProps<NestedReferenceProperties>;
export declare const getImageFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedImageProperties>) => ColumnProps<NestedImageProperties>;
export declare const getSelectionColumnDef: ({ contextType, fieldProperties, }: {
    contextType?: ContextType;
    fieldProperties: Pick<ColumnConfigurationProperties<NestedProperties>["columnProperties"], "_controlObjectType">;
}) => SelectionColumnDef;
export declare const getLabelFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLabelProperties>) => ColumnProps<NestedLabelProperties>;
export declare const getIconFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedIconProperties>) => ColumnProps<NestedIconProperties>;
export declare const getCountFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCountProperties>) => ColumnProps<NestedCountProperties>;
export declare const getCheckboxFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCheckboxProperties>) => ColumnProps<NestedCheckboxProperties>;
export declare const getDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDateProperties>) => ColumnProps<NestedDateProperties>;
export declare const getDatetimeRangeFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDateProperties>) => ColumnProps<NestedDatetimeRangeProperties>;
export declare const getDatetimeFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDateProperties>) => ColumnProps<NestedDatetimeRangeProperties>;
export declare const getValueFormatter: (screenId: string, columnProperties: NestedTextProperties | NestedNumericProperties) => (params: ValueFormatterParams) => string;
export declare const textValueGetter: (props: Pick<ColumnConfigurationProperties<NestedTextProperties>, "screenId" | "columnProperties">) => (params: Pick<ValueGetterParams, "colDef" | "data">) => any;
export declare const getTextFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedTextProperties>) => ColumnProps<NestedTextProperties>;
export declare const getLinkFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLinkProperties>) => ColumnProps<NestedLinkProperties>;
export declare const getRelativeDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedRelativeDateProperties>) => ColumnProps<NestedRelativeDateProperties>;
export declare const getProgressFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedProgressProperties>) => ColumnProps<NestedLinkProperties>;
export declare const getNumericFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
export declare const getAggregateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
export declare const getFilterSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedFilterSelectProperties>) => ColumnProps<NestedFilterSelectProperties>;
export declare const getDropdownListFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDropdownListProperties>) => ColumnProps<NestedDropdownListProperties>;
export declare const getSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSelectProperties>) => ColumnProps<NestedSelectProperties>;
export declare const getSwitchFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSwitchProperties>) => ColumnProps<NestedSwitchProperties>;
export declare const COLUMN_ID_LINE_NUMBER = "__line_number";
export declare const getLineNumberColumnConfiguration: (screenId: string) => AgGridColumnConfigWithScreenIdAndColDef;
export declare const COLUMN_ID_VALIDATIONS = "__validation";
export declare const getValidationColumnConfiguration: (screenId: string, getColumns: () => NestedField<any, any>[]) => AgGridColumnConfigWithAllColumns;
export declare const COLUMN_ID_AUTO_COLUMN = "ag-Grid-AutoColumn";
export declare const COLUMN_ID_ROW_ACTIONS = "__actions";
export declare const COLUMN_CELLCLASS_ROW_ACTIONS = "e-table-field-dropdown-actions-cell";
export declare const FOCUSED_BUT_BORDERLESS = "e-ag-cell-focus--no-border";
export declare const getDropdownActionsColumnConfiguration: (screenId: string, tableElementId: string, level: number, wrapper: WithNestedWrapper<any>["wrapper"], isParentFieldDisabled: boolean, inlineActions: GridRowActionType, dropdownActions: GridRowActionOrMenuSeparatorType, hasFloatingFilters: boolean, collectionValue: () => CollectionValue | undefined, canAddNewLine?: boolean) => AgGridColumnConfigWithScreenIdAndColDef;
export declare const frameworkComponents: Dict<any>;
export type WithNestedWrapper<T> = T & {
    wrapper: React.FC<CellWrapperProps>;
};
export declare function getCellErrorMessage(props: CellParams<any, any>): string | undefined;
export declare function getCellWarningMessage({ data, fieldProperties, screenId }: CellParams<any, any>): string | undefined;
export declare function getCellInfoMessage({ data, fieldProperties, screenId }: CellParams<any, any>): string | undefined;
export declare function getTextAlignment(props: CellParams<any>): 'left' | 'right' | 'center';
export declare function getCellProps<T extends Nested<any>>({ collectionValue, columnId, columnProperties, isParentFieldDisabled, isReadOnly, level, locale, screenId, tableElementId, tableProperties, }: ColumnConfigurationProperties<T>): CellProps<T>;
export interface AddStaticColumnsArgs {
    screenId: string;
    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
    columns?: AgGridColumnConfigWithScreenIdAndColDef[];
    tableElementId: string;
    level: number;
    isParentFieldDisabled: boolean;
    hasFloatingFilters: boolean;
    accessBindings: AccessBindings;
    collectionValue: () => CollectionValue | undefined;
}
export declare const addStaticColumns: ({ accessBindings, columns, fieldProperties, hasFloatingFilters, isParentFieldDisabled, level, screenId, tableElementId, collectionValue, }: AddStaticColumnsArgs) => void;
export declare const COLUMN_ID_ROW_SELECTION = "ag-Grid-ControlsColumn";
export declare const INTERNAL_COLUMN_IDS: string[];
export {};
//# sourceMappingURL=ag-grid-column-config.d.ts.map