import type { Column, SuppressKeyboardEventParams } from '@ag-grid-community/core';
import type { NestedField, NestedFieldTypes } from '../../component/nested-fields';
import type { ScreenBase } from '../../service/screen-base';
export declare function isLeftOrRight(event: React.KeyboardEvent): boolean;
export declare function isCharNumeric(charStr: string): boolean;
export declare function isAllowedDateCharacter(charStr: string): boolean;
export declare function isValidUrl(text: string): boolean;
export declare function getInitialCellEditorState<T>({ eventKey, initialValue, isNumeric, }: {
    eventKey: string | null;
    initialValue: T;
    isNumeric?: boolean;
}): {
    value: T | string;
    highlightOnFocus: boolean;
};
export declare function isKeyPressedNumeric(event: React.KeyboardEvent): boolean;
export declare function isKeyPressedDateComponent(event: React.KeyboardEvent): boolean;
export declare function isFinishedEditingPressed(event: React.KeyboardEvent): boolean;
export declare const defaultCellRendederStyles: React.CSSProperties;
export declare const defaultCellEditorStyles: React.CSSProperties;
export declare const setDefaultAgGridInputStyles: (input: HTMLInputElement) => void;
export declare const getColumnsToExport: (columns: Column[]) => Column[];
export declare const cellExportFormatter: (column: NestedField<ScreenBase, NestedFieldTypes, any>, value?: string | number | null) => string;
export interface GetRowClassRulesOptions {
    canSelect: boolean;
    openedRecordId?: string | number | null;
    isChangeIndicatorDisabled?: boolean;
}
export declare const getRowClassRules: (({ canSelect, openedRecordId, isChangeIndicatorDisabled }: GetRowClassRulesOptions) => any) & import("lodash").MemoizedFunction;
export declare const isBackwardTabOnInput: (keyboardEvent: any) => boolean;
export declare const isForwardTabOnButton: (keyboardEvent: any) => boolean;
export declare const suppressKeyboardEventForReferenceCellEditor: (params: SuppressKeyboardEventParams) => boolean;
export declare const suppressKeyboardEventForContainedTarget: (params: SuppressKeyboardEventParams) => boolean;
export declare const isBackwardTabOnFirstAction: (keyboardEvent: any, index: number) => boolean;
export declare const isForwardTabOnLastAction: (keyboardEvent: any, index: number, length: number) => boolean;
export declare const suppressKeyboardEventForActionCellEditor: (params: SuppressKeyboardEventParams) => boolean;
//# sourceMappingURL=ag-grid-cell-editor-utils.d.ts.map