import { camelCase } from 'lodash';
import { getElementAccessStatusWithoutId } from './access-utils';
import { resolveByValue } from './resolve-value-utils';
import { splitValueToMergedValue } from './transformers';
const getUniqueId = (title, id) => {
    return camelCase(id || title);
};
const getActionMenuTestId = (actionType, title, id) => {
    const uniqueId = getUniqueId(title, id);
    switch (actionType) {
        case 'pod-action':
            return `e-pod-action e-pod-action--${uniqueId} e-action e-action--${uniqueId}`;
        case 'pod-collection-action':
            return `e-pod-collection-action e-pod-collection-action--${uniqueId} e-action e-action--${uniqueId}`;
        case 'table-dropdown-action':
            return `e-table-dropdown-action e-dropdown-action e-dropdown-action--${uniqueId} e-action e-action--${uniqueId}`;
        case 'table-inline-action':
            return `e-table-inline-action e-inline-action e-inline-action--${uniqueId} e-action e-action--${uniqueId}`;
        case 'table-sidebar-header-dropdown-action':
            return `e-table-sidebar-header-dropdown-action e-action e-action--${uniqueId}`;
        case 'table-sidebar-header-quick-action':
            return `e-table-sidebar-header-quick-action e-action e-action--${uniqueId}`;
        default:
            return `e-action e-action--${uniqueId}`;
    }
};
export function calculateActionMenu(args) {
    return calculateActionMenuWithSeparator(args);
}
export function calculateActionMenuWithSeparator({ accessBindings = {}, actions, actionType = 'table-dropdown-action', onTriggerMenuItem, rowValue, screenId, pendoId, }) {
    if (!actions) {
        return [];
    }
    const recordId = rowValue?._id;
    let idx = 0;
    const filterFn = (a) => {
        if (a.isMenuSeparator) {
            return true;
        }
        const accessRule = getElementAccessStatusWithoutId(accessBindings, a.access);
        return accessRule === 'authorized';
    };
    const mapFn = (a) => {
        const isDisabled = resolveByValue({
            screenId,
            propertyValue: a.isDisabled,
            rowValue: splitValueToMergedValue(rowValue),
            fieldValue: recordId,
            skipHexFormat: true,
        }) || false;
        const isHidden = resolveByValue({
            screenId,
            propertyValue: a.isHidden,
            rowValue: splitValueToMergedValue(rowValue),
            fieldValue: recordId,
            skipHexFormat: true,
        }) || false;
        const isDisplayed = resolveByValue({
            screenId,
            propertyValue: a.isDisplayed,
            rowValue,
            fieldValue: recordId,
            skipHexFormat: true,
        });
        const { children: hasChildren } = a;
        const children = hasChildren ? hasChildren.filter(filterFn).map(mapFn) : [];
        const { isDestructive, onClick } = a;
        const context = {
            id: camelCase(a.id),
            uniqueId: camelCase(a.id || a.title),
        };
        idx += 1;
        if (a.isMenuSeparator) {
            const key = `${idx}_${a.id}` || `${idx}_menu_separator`;
            return {
                isDisplayed,
                isHidden,
                isMenuSeparator: true,
                key,
                priority: idx,
                testId: getActionMenuTestId(actionType, key, a.id),
            };
        }
        return {
            childrenProp: children,
            icon: a.icon,
            isDisabled,
            isDisplayed,
            isHidden,
            isDestructive,
            isMenuSeparator: false,
            key: `${idx}_${a.title}`,
            onClick: () => (isDisabled ? undefined : onTriggerMenuItem(context, onClick, a.onError)),
            priority: idx,
            testId: getActionMenuTestId(actionType, a.title, a.id),
            title: a.title,
            pendoId: pendoId && context.id ? `${pendoId}-${context.id}` : undefined,
        };
    };
    return actions.filter(filterFn).map(mapFn);
}
export function menuSeparator({ id, insertAfter, insertBefore } = {}) {
    return {
        id,
        insertAfter,
        insertBefore,
        isMenuSeparator: true,
    };
}
//# sourceMappingURL=action-menu-utils.js.map