import type { DropdownActionItem, DropdownActionItemOrMenuSeparator, ErrorHandlerFunction } from '../component/field/traits';
import type { CollectionItemAction, CollectionItemActionGroup, CollectionItemActionOrMenuSeparator, NestedCollectionItemAction, NestedCollectionItemActionGroup, NestedCollectionItemActionOrMenuSeparator } from '../component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
import type { XtremActionPopoverItem, XtremActionPopoverItemOrMenuSeparator } from '../component/ui/xtrem-action-popover';
import type { AccessBindings } from '../service/page-definition';
export type ActionType = 'pod-action' | 'pod-collection-action' | 'table-dropdown-action' | 'table-inline-action' | 'table-sidebar-header-dropdown-action' | 'table-sidebar-header-quick-action';
type ActionMenuLike = DropdownActionItem<any> | CollectionItemAction<any> | CollectionItemActionGroup<any> | NestedCollectionItemAction<any> | NestedCollectionItemActionGroup<any>;
type ActionMenuOrSeparatorLike = DropdownActionItemOrMenuSeparator<any> | CollectionItemActionOrMenuSeparator<any> | CollectionItemActionGroup<any> | NestedCollectionItemActionOrMenuSeparator<any> | NestedCollectionItemActionGroup<any>;
export interface CalculateActionMenuPropsWithSeparator {
    accessBindings: AccessBindings;
    actions?: Array<ActionMenuOrSeparatorLike>;
    actionType: ActionType;
    onTriggerMenuItem: (context: {
        id?: string;
        uniqueId: string;
    }, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
    pendoId?: string;
    rowValue?: any;
    screenId: string;
}
export interface CalculateActionMenuProps {
    accessBindings: AccessBindings;
    actions?: Array<ActionMenuLike>;
    actionType: ActionType;
    onTriggerMenuItem: (context: {
        id?: string;
        uniqueId: string;
    }, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
    pendoId?: string;
    rowValue?: any;
    screenId: string;
}
export declare function calculateActionMenu(args: CalculateActionMenuProps): Array<XtremActionPopoverItem>;
export declare function calculateActionMenuWithSeparator(args: CalculateActionMenuPropsWithSeparator): Array<XtremActionPopoverItemOrMenuSeparator>;
export interface MenuSeparatorOptions {
    id?: string;
    insertAfter?: string;
    insertBefore?: string;
}
export interface MenuSeparatorResult {
    id?: string;
    insertAfter?: string;
    insertBefore?: string;
    isMenuSeparator: true;
}
export declare function menuSeparator({ id, insertAfter, insertBefore }?: MenuSeparatorOptions): MenuSeparatorResult;
export {};
//# sourceMappingURL=action-menu-utils.d.ts.map