import { isDevMode } from './window';
import { get } from 'lodash';
import { findDeepPropertyDetails } from './node-utils';
import { schemaTypeNameFromNodeName } from './transformers';
export const getElementAccessStatus = ({ accessBindings, 
// TODO: handle nested access rights
bind, elementProperties, contextNode, nodeTypes, }) => {
    const accessNode = elementProperties.access?.node || contextNode;
    const accessBind = elementProperties.access?.bind || elementProperties.bind || bind;
    if (!accessNode) {
        return undefined;
    }
    // Actions are not on the node types, so we need to handle them separately
    if (accessBind[0] === '$') {
        return accessBindings[schemaTypeNameFromNodeName(String(accessNode))]?.[accessBind] || undefined;
    }
    const propertyDetails = findDeepPropertyDetails(schemaTypeNameFromNodeName(String(accessNode)), accessBind, nodeTypes);
    if (!propertyDetails || !propertyDetails.name) {
        return undefined;
    }
    return accessBindings[propertyDetails.parentNode]?.[propertyDetails.name] || undefined;
};
export const getBulkActionAccessStatus = (accessBindings, bulkActionId, node, access) => {
    const bulkActionNode = access?.node ?? node;
    const bulkActionBind = access?.bind ?? bulkActionId;
    return accessBindings[schemaTypeNameFromNodeName(String(bulkActionNode))]?.[bulkActionBind] || undefined;
};
export const getElementAccessStatusWithoutId = (accessBindings, access) => {
    if (!access) {
        return 'authorized';
    }
    if (!access.bind || !access.node) {
        if (isDevMode()) {
            throw new Error('Invalid access definition, you must define both bind and node properties.');
        }
        return 'authorized';
    }
    return get(accessBindings, `${schemaTypeNameFromNodeName(access.node)}.${access.bind}`, 'unauthorized');
};
//# sourceMappingURL=access-utils.js.map