import { type Dict } from '@sage/xtrem-shared';
import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from './metadata-types';
import type { ScreenBaseDefinition } from './screen-base-definition';
/**
 * Formats any data to a GraphQL input based on provided node type definition.
 * It checks the expected GraphQL input type and converts the value to it wherever it is possible. In case of nested structures in
 * converts the properties deeply by following the graph definitions.
 *
 * Whenever a client side value cannot be converted to the server defined type (e.g. boolean to an object), an exception is thrown
 *
 * @param param0
 * @returns
 */
export declare const formatInputProperty: ({ isRequestingDefaults, isTopLevel, nodeTypes, property, value, }: {
    property: FormattedNodeDetailsProperty;
    value: any;
    nodeTypes: Dict<FormattedNodeDetails>;
    isRequestingDefaults?: boolean;
    isTopLevel?: boolean;
}) => any;
export interface SerializePageDataParams {
    screenDefinition: ScreenBaseDefinition;
    nodeTypes: Dict<FormattedNodeDetails>;
    targetNode: string;
    isRequestingDefaults?: boolean;
}
/**
 * Builds the mutation `data` payload from the values and properties, first it normalizes the value structure and filters out the
 * non saveable fields, then format the values to match the input value.
 */
export declare const serializePageData: ({ screenDefinition, isRequestingDefaults, nodeTypes, targetNode, }: SerializePageDataParams) => any;
//# sourceMappingURL=value-serializer-service.d.ts.map