import type { ClientNode } from '@sage/xtrem-client';
import { type Dict } from '@sage/xtrem-shared';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { ReadonlyFieldControlObject, ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { CollectionItem, ComponentKey } from '../component/types';
import type { FormattedNodeDetails } from './metadata-types';
import type { PageDefinition } from './page-definition';
import type { XtremUiPlugin } from './plugin-service';
import type { ScreenBase } from './screen-base';
import type { UiComponentUserSettings } from '../redux/state';
/**
 * Formats a single field into a suitable format based on its server-side GraphQL type or the corresponding control
 * object
 *
 * @param screenId
 * @param elementId
 * @param nodeTypes
 * @param fieldType
 * @param fieldProperties
 * @param value
 * @param parentNode
 */
export declare const formatValue: ({ pageDefinition, elementId, fieldProperties, fieldType, nodeTypes, parentNode, plugins, rowValue, screenId, value, userSettings, }: {
    pageDefinition?: PageDefinition;
    elementId: string;
    fieldProperties: ReadonlyFieldProperties;
    fieldType: ComponentKey;
    nodeTypes: Dict<FormattedNodeDetails>;
    parentNode?: string;
    plugins: Dict<XtremUiPlugin>;
    rowValue?: any;
    screenId: string;
    value?: any;
    userSettings: Dict<UiComponentUserSettings>;
}) => any;
export interface FormatCollectionItemArgs<T extends ClientNode = any> {
    screenId: string;
    nodeTypes: Dict<FormattedNodeDetails>;
    collectionItem: CollectionItem;
    plugins?: Dict<XtremUiPlugin>;
    columnsDefinitions: NestedField<ScreenBase, NestedFieldTypes, T>[];
    parentNode?: string;
    contextRow?: any;
}
/**
 * Format all values of a nested collection item into client-side suitable format based on various rules depending on
 * the server-side node GraphQL types and the control object types.
 * @param screenId
 * @param nodeTypes
 * @param collectionItem
 * @param columnsDefinitions
 * @param parentNode
 */
export declare const formatCollectionItem: <T extends ClientNode = any>({ screenId, nodeTypes, collectionItem, plugins, columnsDefinitions, parentNode, contextRow, }: FormatCollectionItemArgs<T>) => T;
/**
 * Format all values of a screen into client-side suitable format based on various rules depending on the server-side
 * node GraphQL types and the control object types.
 *
 * If the `onlyElementIds` parameter is supplied, it will only format those values which are provided in this parameter.
 *
 * @param screenId
 * @param controlObjects
 * @param uiComponentProperties
 * @param nodeTypes
 * @param values
 * @param parentNode
 */
export declare const formatScreenValues: ({ controlObjects, nodeTypes, onlyElementIds, pageDefinition, parentNode, plugins, screenId, userSettings, values, }: {
    controlObjects: Dict<ReadonlyFieldControlObject<any, any, any>>;
    nodeTypes: Dict<FormattedNodeDetails>;
    onlyElementIds?: string[];
    pageDefinition?: PageDefinition;
    parentNode?: string;
    plugins: Dict<XtremUiPlugin>;
    screenId: string;
    userSettings: Dict<Dict<UiComponentUserSettings>>;
    values: Dict<any>;
}) => Dict<any>;
//# sourceMappingURL=value-formatter-service.d.ts.map