import { executeGraphqlQuery } from './graphql-utils';
export async function fetchUserClientSettingsForElement(screenId, elementId) {
    const response = await executeGraphqlQuery({
        endpoint: '/metadata',
        query: {
            clientUserSettings: {
                variantsForElement: {
                    __args: {
                        screenId,
                        elementId,
                    },
                    _id: true,
                    title: true,
                    description: true,
                    content: true,
                },
            },
        },
    });
    return response.data.clientUserSettings.variantsForElement
        .map((v) => ({
        ...v,
        content: JSON.parse(v.content || '{}'),
    }))
        .sort((a, b) => a.title.localeCompare(b.title));
}
export async function unselectView(screenId, elementId) {
    await executeGraphqlQuery({
        endpoint: '/metadata',
        query: {
            mutation: {
                clientUserSettings: {
                    unselectClientUserSettings: {
                        __args: {
                            screenId,
                            elementId,
                        },
                        _id: true,
                    },
                },
            },
        },
    });
}
export async function selectView(screenId, elementId, viewId) {
    await executeGraphqlQuery({
        endpoint: '/metadata',
        query: {
            mutation: {
                clientUserSettings: {
                    setCurrentUserClientSetting: {
                        __args: {
                            screenId,
                            elementId,
                            _id: viewId,
                        },
                        _id: true,
                        title: true,
                        description: true,
                        content: true,
                    },
                },
            },
        },
    });
}
//# sourceMappingURL=user-client-settings-service.js.map