const keyPrefix = 'xtrem_';
/** Add a single entry from the storage */
export const set = (key, value) => {
    window.sessionStorage.setItem(keyPrefix + key, JSON.stringify(value));
};
/** Get a single entry from the storage */
export const get = (key) => {
    const item = window.sessionStorage.getItem(keyPrefix + key);
    if (item) {
        return JSON.parse(item);
    }
    return null;
};
/** Get all entries from the storage as a dictionary */
export const getAll = () => {
    const dict = {};
    for (let i = 0; i < window.sessionStorage.length; i += 1) {
        const key = window.sessionStorage.key(i);
        if (key && key.indexOf(keyPrefix) === 0) {
            const replacedKey = key.replace(keyPrefix, '');
            dict[replacedKey] = get(replacedKey);
        }
    }
    return dict;
};
/** Removes a single entry from the storage */
export const remove = (key) => {
    window.sessionStorage.removeItem(keyPrefix + key);
};
//# sourceMappingURL=storage-service.js.map