import { objectKeys } from '@sage/xtrem-shared';
import { getStore as shortcutService } from '../redux';
const currentSequence = [];
const registeredCombinations = {};
// For testing
export const getCurrentKeySequence = () => {
    return [...currentSequence];
};
export const clearKeyCombination = () => {
    objectKeys(registeredCombinations).forEach(k => {
        delete registeredCombinations[k];
    });
    currentSequence.splice(0, currentSequence.length);
};
const multiKeys = ['Shift', 'Meta', 'Control', 'Alt'];
const normalizeKey = (event) => {
    // BL: Some selenium based tests do not provide the KEY on the event, we need to handle that
    if (event.key && event.code) {
        let key = event.code.replace('Key', '');
        multiKeys.forEach(k => {
            if (key.indexOf(k) === 0) {
                key = key.replace('Right', '').replace('Left', '');
            }
        });
        key = key.toLowerCase();
        return key === 'meta' ? 'control' : key;
    }
    return 'unknown';
};
document.addEventListener('keydown', (event) => {
    const key = normalizeKey(event);
    if (currentSequence.indexOf(key) === -1 && key !== 'dead') {
        currentSequence.push(key);
        const sortedCombination = currentSequence;
        sortedCombination.sort();
        // eslint-disable-next-line no-restricted-syntax
        for (const keyCombination of Object.values(registeredCombinations).reverse()) {
            if (shortcutService().getState().isKeyboardShortcutsEnabled &&
                keyCombination.combination.length === sortedCombination.length &&
                keyCombination.combination.every(e => sortedCombination.includes(e))) {
                event.preventDefault();
                event.stopPropagation();
                keyCombination.callback();
                return false;
            }
        }
    }
    return true;
});
document.addEventListener('keyup', (event) => {
    const normalizedKey = normalizeKey(event);
    const index = currentSequence.indexOf(normalizedKey);
    if (index !== -1) {
        currentSequence.splice(index, 1);
    }
});
// Clean up keys when the user navigates away from the window
window.addEventListener('blur', () => {
    currentSequence.splice(0, currentSequence.length);
});
let id = 1;
export const subscribe = (combination, callback) => {
    id += 1;
    const sortedCombination = Array.isArray(combination) ? combination : [combination];
    sortedCombination.sort();
    registeredCombinations[id] = {
        combination: sortedCombination,
        callback,
    };
    return id;
};
export const unsubscribe = (shortcutSubscriptionId) => {
    if (shortcutSubscriptionId !== null) {
        delete registeredCombinations[shortcutSubscriptionId];
    }
};
//# sourceMappingURL=shortcut-service.js.map