import type { Dict } from '@sage/xtrem-shared';
import type { AbstractWidget } from '../dashboard/widgets/abstract-widget';
import type { AppThunkDispatch, XtremAppState } from '../redux';
import type { ApplicationContext } from '../redux/state';
import type { Constructible } from '../types';
import type { QueryParameters } from '../utils/types';
import type { ArtifactType, MetadataResponse } from './metadata-types';
import type { PageDefinition } from './page-definition';
import type { StickerDefinition } from './sticker-definition';
export declare const getXtremArtifactVariable: () => Dict<Constructible<any>>;
export declare const getDeclarationPackage: () => string;
declare global {
    let xtremArtifact: Dict<Constructible<any>>;
}
/**
 * Fetches the plugin source code from the server or restores it from the cache.
 *
 * @param pluginPackage
 * @param applicationContext
 * @param cache
 * @returns plugin source code
 */
export declare function fetchPlugin(pluginPackage: string, applicationContext: ApplicationContext, version: string, cache?: Cache): Promise<string>;
/**
 * Check and evaluate raw Xtrem UI plugin script content. If the plugin is compliant with the expected standards, then
 * it will be added to the application state.
 **/
export declare const loadPlugins: (dispatch: AppThunkDispatch, plugins: string[], applicationContext: ApplicationContext, loadedPlugins: string[], applicationPackages: Dict<string>) => Promise<void>;
export declare const processStringLiteralsFromResponse: (metadataType: ArtifactType | undefined, response: MetadataResponse) => Dict<string>;
/**
 * Fetches the page definition corresponding to the path from the server and evaluates the javascript response
 *
 * @param path the xtrem path in string format
 */
export declare const fetchPageDefinition: ({ getState, dispatch, path, isMainPage, queryParameters, values, onFinish, isDuplicate, }: {
    getState: () => XtremAppState;
    dispatch: AppThunkDispatch;
    path: string;
    isMainPage?: boolean;
    queryParameters?: QueryParameters;
    values?: Dict<any>;
    onFinish?: (values?: Dict<any>) => void;
    isDuplicate?: boolean;
}) => Promise<PageDefinition | null>;
/**
 * Fetches the sticker definition corresponding to the path from the server and evaluates the javascript response
 *
 * @param path the xtrem path in string format
 */
export declare const fetchStickerDefinition: (getState: () => XtremAppState, dispatch: AppThunkDispatch, path: string, onFinish?: (values?: Dict<any>) => void) => Promise<StickerDefinition | null>;
/**
 * Fetches the sticker definition corresponding to the path from the server and evaluates the javascript response
 *
 * @param path the xtrem path in string format
 */
export declare const fetchWidgetDefinitions: (getState: () => XtremAppState, dispatch: AppThunkDispatch, widgetsToLoad: string[]) => Promise<Dict<Constructible<AbstractWidget>> | null>;
//# sourceMappingURL=screen-loader-service.d.ts.map