/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientError, ClientNode } from '@sage/xtrem-client';
import { type Dict, type Locale } from '@sage/xtrem-shared';
import type React from 'react';
import type { PageActionControlObject } from '../component/control-objects';
import type { IDialogApi } from '../types/dialogs';
import type { ContainerValidationResult } from './dispatch-service';
import { GraphQLApi } from './graphql-api';
import type { Loader } from './loader';
import type { PageMetadata } from './page-metadata';
import type { IRouter } from './router';
import { SoundApi } from './sound-api';
import * as storageService from './storage-service';
import type { ToastOptions } from './toast-service';
export declare abstract class BaseDeveloperApi<TGraphqlApi, CT extends ScreenBase<TGraphqlApi>> {
    readonly router: IRouter;
    readonly dialog: IDialogApi<CT>;
    readonly loader: Loader;
    readonly sound: SoundApi;
    readonly showToast: (content: string | React.ReactNode, options?: ToastOptions) => void;
    readonly showValidationToast: (containerValidationErrors: ContainerValidationResult, options?: ToastOptions) => void;
    readonly removeToasts: () => void;
    constructor(screenId: string);
    /**
     * Returns the unique ID (email address) of the user that is currently uses the application
     */
    get username(): string | null;
    /**
     * The session username can be used if the application has a username that is different from the login user.
     */
    get userCode(): string | null;
    get locale(): Locale | null;
    /** Cross-page storage object that preserves the content for the session */
    get storage(): storageService.Storage;
}
export declare abstract class DeveloperApi<TGraphqlApi, CT extends ScreenBase<TGraphqlApi> = any> extends BaseDeveloperApi<TGraphqlApi, CT> {
    protected readonly screenBase: CT;
    readonly graph: GraphQLApi<TGraphqlApi>;
    readonly router: IRouter;
    readonly dialog: IDialogApi<CT>;
    readonly loader: Loader;
    readonly showToast: (content: string | React.ReactNode, options?: ToastOptions) => void;
    readonly showValidationToast: (containerValidationErrors: ContainerValidationResult, options?: ToastOptions) => void;
    readonly removeToasts: () => void;
    constructor(screenBase: CT);
    subscribeToEvent(category: string, callback: (...args: any[]) => void): void;
    unsubscribeFromEvent(category: string, callback: (...args: any[]) => void): void;
    /**
     * Returns a new object containing the values of all the page's non-transient fields.
     * It is a heavy operation that serializes all values of the page. It should only be used
     * when you need the value of most of the fields in a server friendly way.
     */
    get values(): Dict<any>;
    set values(boundValues: Dict<any>);
    get businessActions(): PageActionControlObject<ScreenBase>[];
    setPageClean(): void;
    /** Whether the page currently contains any dirty fields */
    get isDirty(): boolean;
    isTransactionInProgress(): boolean;
    /** Update the screen with the changes that were applied by the functional code. */
    commitValueAndPropertyChanges(): Promise<void>;
    finish(result?: any): void;
    processServerErrors(error: ClientError): Promise<void>;
    isServiceOptionEnabled(serviceOptionName: string): boolean;
    getEnabledServiceOptions(): string[];
}
export declare abstract class ScreenBase<TGraphqlApi = any, _TNodeType extends ClientNode = any> {
    readonly _pageMetadata: PageMetadata;
    abstract $: DeveloperApi<TGraphqlApi>;
    $standardDeleteButton: string;
    $standardCancelButton: string;
    /**
     * Confirmation dialog title for the standard CRUD delete platform action.
     * Override this property to change the dialog title.
     * */
    $standardDeletePromptTitle: string;
    /**
     * Confirmation dialog message content for the standard CRUD delete platform action.
     * Override this property to change the dialog title.
     * */
    $standardDeletePromptMessage: string;
    /**
     * Toast content for the standard CRUD save platform action for successfully updating an existing record.
     * Override this property to change the content of the toast.
     * */
    $standardSaveSuccessMessage: string;
    /**
     * Toast content for the standard CRUD save platform action for successfully creating an existing record.
     * Override this property to change the content of the toast.
     * */
    $standardCreateSuccessMessage: string;
    /**
     * Toast content for the standard CRUD save platform action for save failure.
     * Override this property to change the content of the toast.
     * */
    $standardSaveFailedMessage: string;
    /**
     * Toast content for the standard CRUD duplicate platform action for duplication failure.
     * Override this property to change the content of the toast.
     * */
    $standardDuplicateFailedMessage: string;
    constructor();
    /**
     * This function serializes the pages values into a format that is ready for server operations. This function is used
     * by the standard CRUD actions, by overriding this function, the application developers can control what values are
     * sent to the server.
     *
     * @returns serializable data which will be used for server interactions
     */
    getSerializedValues(): any;
}
//# sourceMappingURL=screen-base.d.ts.map