/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { BlockControlObject, DetailPanelControlObject, MultiFileDepositControlObject, PageAction, PageControlObject, PageMode } from '../component/control-objects';
import type { ReadonlyFieldControlObject } from '../component/readonly-field-control-object';
import type { PageArticleItem } from './layout-types';
import { DeveloperApi, ScreenBase } from './screen-base';
export declare class PageDeveloperApi<TGraphqlApi, CT extends ScreenBase<TGraphqlApi>> extends DeveloperApi<TGraphqlApi, CT> {
    private readonly _detailPanel;
    private readonly _headerLineBlock;
    constructor(page: Page<TGraphqlApi>);
    private get screenId();
    /** Light-weight function that returns the ID of the page from the query parameters */
    get recordId(): string | undefined;
    get isNavigationPanelHidden(): boolean;
    set isNavigationPanelHidden(state: boolean);
    get hasAttachmentsDialog(): boolean;
    get attachments(): MultiFileDepositControlObject | null;
    get headerLineBlock(): Partial<PageArticleItem> | null;
    get queryParameters(): Dict<string | number | boolean>;
    /** Container that can be used to display additional information outside of the page layout */
    get detailPanel(): DetailPanelControlObject | null;
    /** This page */
    get page(): PageControlObject;
    /** Visualization mode */
    get mode(): PageMode;
    refreshNavigationPanel(recordAdded?: boolean): Promise<void>;
    get isInDialog(): boolean;
    get isInDuplicationDialog(): boolean;
    get isInTunnel(): boolean;
    get isNewPage(): boolean;
    /**
     * Fetch default values from the server even if those fields are dirty.
     * If the `skipSet` argument is set to true, the values are requested from the server but not applied to the page.
     */
    fetchDefaults(requestedFieldIds: (string | ReadonlyFieldControlObject<any, any, any>)[], skipSet?: boolean): Promise<Dict<any>>;
}
export declare abstract class Page<TGraphqlApi = any, TNodeType extends ClientNode = any> extends ScreenBase<TGraphqlApi, TNodeType> {
    readonly $: PageDeveloperApi<TGraphqlApi, typeof this>;
    /**
     * Standard Delete CRUD action. First it displays a confirmation prompt, then if the user confirms it calls the
     * `delete` mutation associated with the page node.
     */
    readonly $standardDeleteAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Standard Save CRUD action. If the record has a valid ID, it calls the associated page node's `update` mutation,
     * if not it calls the `create` mutation.
     */
    readonly $standardSaveAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Empties the page to for creating a new record.
     */
    readonly $standardNewAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Restores the page to its original state.
     */
    readonly $standardCancelAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Opens duplication page in a dialog.
     */
    readonly $standardDuplicateAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Executes the duplication graph mutation.
     */
    readonly $standardExecuteDuplicationAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Opens the customization wizard if the application is configured with a customization manager and the page has customizable nodes
     */
    readonly $standardOpenCustomizationPageWizardAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Opens a simple dialog with information about the record's history.
     */
    readonly $standardOpenRecordHistoryAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    /**
     * Closes the page dialog and serializes its value into the dialog result
     */
    readonly $standardDialogConfirmationAction: PageAction<Page<TGraphqlApi, TNodeType>>;
    constructor();
    /** Block that provides highlighted information, relevant to the current page, through labels and icons */
    $header?: BlockControlObject<Page<TGraphqlApi, TNodeType>>;
}
export declare abstract class PageFragment<TGraphqlApi = any, TNodeType extends ClientNode = any> extends Page<TGraphqlApi, TNodeType> {
}
//# sourceMappingURL=page.d.ts.map