let preferredScreenId;
export const setPreferredScreenId = (screenId) => {
    preferredScreenId = screenId;
};
export const unsetPreferredScreenId = () => {
    preferredScreenId = null;
};
export const getNewPageMetadata = (screenId, target) => {
    const defaultMetadata = {
        blockThunks: {},
        businessActionsExtensionsThunk: [],
        controlObjects: {},
        customizations: {},
        defaultUiComponentProperties: {},
        definitionOrder: [],
        elementsWithShortcut: [],
        extensionOverrideThunks: {},
        fieldBindings: {},
        fieldThunks: {},
        fragmentFields: {},
        fragmentFieldsThunks: {},
        hasRecordPrintingTemplates: false,
        isTransient: false,
        layout: { $items: [] },
        layoutBlocks: {},
        layoutFields: {},
        pageActions: {},
        pageActionThunks: {},
        pageExtensionThunks: [],
        pageFragmentThunks: [],
        screenId,
        sectionThunks: {},
        target,
        uiComponentProperties: {},
    };
    return defaultMetadata;
};
/**
 * Get the page metadata object from the constructor
 *
 * The metadata object is added to the constructor of the page which is being built because all decorator functions
 * have direct access to the object constructor, so it is an easy way to have a global shared object.
 */
export const getPageMetadata = (pageConstructor, target) => {
    /**
     * Checks if the constructor already has a metadata object assigned, if not it creates and assigns a new one. Only
     * a single metadata object should be created for every page load.
     *  */
    const currentMetadataObject = pageConstructor._pageMetadata;
    if (!currentMetadataObject) {
        const defaultMetadataObject = getNewPageMetadata(preferredScreenId || pageConstructor.name, target);
        pageConstructor._pageMetadata = defaultMetadataObject;
        return defaultMetadataObject;
    }
    if (!currentMetadataObject.target) {
        currentMetadataObject.target = target;
    }
    return currentMetadataObject;
};
//# sourceMappingURL=page-metadata.js.map