import { cloneDeep } from 'lodash';
import { getPageMetadata } from './page-metadata';
import { applyDuplicationBusinessActions, applyDuplicationLayoutStructure } from '../utils/duplication-utils';
const PAGE_DEFINITION_ROOT = {
    accessBindings: {},
    dirtyStates: {},
    errors: {},
    insightCount: 0,
    internalErrors: {},
    isInDialog: false,
    isReady: false,
    queryParameters: {},
    selectedRecordId: null,
    values: {},
};
export const getNewPageDefinition = () => cloneDeep(PAGE_DEFINITION_ROOT);
export const getPageDefinition = (pageConstructor, 
/** Full artifact path */
path, isMainPage, isDuplicate = false) => {
    const pageDefinition = {
        ...getNewPageDefinition(),
        metadata: getPageMetadata(pageConstructor),
        // eslint-disable-next-line new-cap
        page: new pageConstructor(),
        path,
        isMainPage,
        type: 'page',
    };
    if (isDuplicate) {
        applyDuplicationBusinessActions(pageDefinition);
        applyDuplicationLayoutStructure(pageDefinition);
        // Remove businessActionsExtensionsThunk from the pageDefinition
        pageDefinition.metadata.businessActionsExtensionsThunk = [];
    }
    return pageDefinition;
};
//# sourceMappingURL=page-definition.js.map