import type { AccessStatus, Dict } from '@sage/xtrem-shared';
import type { Constructible } from '../types';
import type { Page } from './page';
import type { ScreenBaseDefinition } from './screen-base-definition';
import type { QueryParameters } from '../utils/types';
export type AccessBindings = Dict<Dict<AccessStatus>>;
export interface PageDefinition extends ScreenBaseDefinition {
    activeSection: string | null;
    insightCount: number;
    is360ViewOn?: boolean;
    isHeaderSectionClosed?: boolean;
    isInDialog: boolean;
    isMainPage: boolean;
    isReady: boolean;
    page: Page;
    path: string;
    queryParameters: QueryParameters;
    selectedRecordId: string | null;
}
export declare const getNewPageDefinition: () => Partial<PageDefinition>;
export declare const getPageDefinition: (pageConstructor: Constructible<Page>, 
/** Full artifact path */
path: string, isMainPage: boolean, isDuplicate?: boolean) => PageDefinition;
//# sourceMappingURL=page-definition.d.ts.map