import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import type { PrintingSettings, UiComponentUserSettings } from '../redux/state';
import type { GraphqlCacheSettings } from './graphql-utils';
import type { ArtifactType, DataTypeDetails, FormattedNodeDetails, MetadataResponse, ModuleEntryProperties, RawNodeDetails } from './metadata-types';
import type { ScreenBaseDefinition } from './screen-base-definition';
export interface ProcessedNodeDetails {
    dataTypes: Dict<DataTypeDetails>;
    nodeTypes: Dict<FormattedNodeDetails>;
    enumTypes: Dict<{
        values: string[];
        name: string;
        translations: string[];
    }>;
}
export declare const fetchEnumTranslations: (enums: string[], locale: string) => Promise<Dict<string>>;
export declare function processNodeDetailsResponse(rawNodeDetails?: RawNodeDetails[]): ProcessedNodeDetails;
/**
 * @param withSortValue When true, the _sortValue property will be included in the returned properties
 */
export declare function fetchNodeDetailsResponse(nodes: string[], depth?: number, cacheSettings?: GraphqlCacheSettings, withSortValue?: boolean): Promise<any>;
/**
 * @param withSortValue When true, the _sortValue property will be included in the returned properties
 */
export declare function fetchNodeDetails(nodes: string[], depth?: number, cacheSettings?: GraphqlCacheSettings, withSortValue?: boolean): Promise<{
    dataTypes: Dict<DataTypeDetails>;
    nodeTypes: Dict<FormattedNodeDetails>;
    enumTypes: Dict<{
        values: string[];
        name: string;
        translations: string[];
    }>;
}>;
export declare function fetchNodePackageNames(nodes: string[], depth?: number, cacheSettings?: GraphqlCacheSettings): Promise<string[]>;
export declare function fetchInitialNodeDetails(screenDefinition: ScreenBaseDefinition, pagePackageVersion: string, locale: LocalizeLocale, knownNodeTypes?: string[]): Promise<{
    dataTypes: Dict<DataTypeDetails>;
    nodeTypes: Dict<FormattedNodeDetails>;
    enumTypes: Dict<{
        values: string[];
        name: string;
        translations: string[];
    }>;
}>;
export declare const fetchInitialEnumSchemaInfo: (screenDefinition: ScreenBaseDefinition, pagePackageVersion: string, locale: LocalizeLocale, knownEnumTypes?: string[]) => Promise<Dict<{
    values: string[];
    name: string;
    translations: string[];
}>>;
export declare const fetchEnumDefinitions: (enums: string[], cacheSettings?: GraphqlCacheSettings) => Promise<Dict<{
    name: string;
    values: string[];
    translations: string[];
}>>;
export declare const fetchDataTypeDefinitions: (typeNames: string[]) => Promise<Dict<DataTypeDetails>>;
export declare const purgeMetaDataCache: () => Promise<void>;
export interface QueryMetadataArgs {
    applicationPackages?: Dict<string>;
    metadataType: ArtifactType;
    metadataProperties: ModuleEntryProperties[];
    path?: string;
    shouldFetchPlatformLiterals?: boolean;
    exactMatch?: boolean;
    locale?: string;
    node?: string;
}
export declare const queryMetadata: ({ applicationPackages, metadataType, metadataProperties, path, shouldFetchPlatformLiterals, locale, exactMatch, node, }: QueryMetadataArgs) => Promise<MetadataResponse>;
export type InstalledPackageList = Array<{
    name: string;
    version: string;
}>;
export interface InitialMetadataQueryResult {
    installedPackages: InstalledPackageList;
    customizationWizardPage: string | null;
    exportConfigurationPage: string | null;
    clientUserSettings: {
        editPage: string | null;
        listPage: string | null;
    };
    printingSettings: PrintingSettings | null;
    serviceOptions: Array<{
        name: string;
        isActive: boolean;
    }>;
}
export declare const queryInitialMetadata: () => Promise<InitialMetadataQueryResult>;
export declare const queryPagesByNodeType: ((pageNode: string) => Promise<Array<{
    key: string;
    title: string;
}>>) & import("lodash").MemoizedFunction;
export declare function updateUserClientSettings(view: UiComponentUserSettings): Promise<void>;
export declare function createUserClientSettings(screenId: string, elementId: string, view: UiComponentUserSettings): Promise<string>;
//# sourceMappingURL=metadata-service.d.ts.map