import lokijs from '@sage/lokijs';
import type { ClientNode, ExtractEdgesPartial } from '@sage/xtrem-client';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { PartialCollectionValue, PartialCollectionValueWithIds } from '../component/types';
import type { CollectionGlobalValidationState, InternalValue, NormalizedCollection } from './collection-data-types';
import type { ScreenBase } from './screen-base';
type LokiOptions<T extends ClientNode = any> = {
    dbKey?: string;
    elementId: string;
    initialValues: PartialCollectionValue<T>[];
    isTransient: boolean;
    screenId: string;
};
export declare const extendLokiOperators: () => void;
export declare const destroyScreenCollections: (screenId: string, keepNavigationPanelDb?: boolean) => void;
export declare class LokiDb<T extends ClientNode = any> implements NormalizedCollection<T> {
    protected readonly collection: lokijs.Collection<InternalValue<T>>;
    protected minId: number;
    protected result: Resultset<InternalValue<T> & LokiObj> | null;
    protected readonly screenId: string;
    protected readonly elementId: string;
    static getCollectionId(screenId: string, elementId: string, dbKey?: string): string;
    constructor({ screenId, elementId, initialValues, isTransient, dbKey }: LokiOptions<T>);
    static groupBy(input: any[], groupKey: string): any;
    calculateAggregatedValue({ aggregationKey, aggregationMethod, ...findAllParams }: Parameters<NormalizedCollection<T>['calculateAggregatedValue']>[0]): number;
    withTemporaryRecords<B>(body: (db: this) => B, temporaryRecords?: ExtractEdgesPartial<T>[]): B;
    getCompositeKey({ _id, __level, __isGroup: isGroup, __groupKey: groupKey, __uncommitted, }: {
        _id: string;
        __level?: number;
        __isGroup?: boolean;
        __groupKey?: string;
        __uncommitted?: boolean;
    }): string;
    getPathProperty(record: {
        _id: string;
        __level?: number;
        __parentId?: string;
        __uncommitted?: boolean;
    }): string;
    getIdAndLevelFromCompositeKey(compositeKey: string): {
        _id: string;
        __level?: number;
    };
    protected ensureResult(): void;
    generateIndex(): string;
    /** Prepare the collection information for server side processing. Generated IDs and LokJS flags removed */
    exportDataForServerProcessing(): T[];
    findOne(args: {
        id?: string;
        level?: number | null;
        parentId?: string;
        where?: LokiQuery<InternalValue<T>>;
        cleanMetadata?: undefined;
        includeUnloaded?: boolean;
        isUncommitted?: boolean;
    }): PartialCollectionValueWithIds<T>;
    findOne(args: {
        id?: string;
        level?: number | null;
        parentId?: string;
        where?: LokiQuery<InternalValue<T>>;
        cleanMetadata?: true;
        includeUnloaded?: boolean;
        isUncommitted?: boolean;
    }): PartialCollectionValueWithIds<T>;
    findOne(args: {
        id?: string;
        level?: number | null;
        parentId?: string;
        where?: LokiQuery<InternalValue<T>>;
        cleanMetadata?: false;
        includeUnloaded?: boolean;
        isUncommitted?: boolean;
    }): InternalValue<T>;
    findOne(args: {
        id?: string;
        level?: number | null;
        parentId?: string;
        where?: LokiQuery<InternalValue<T>>;
        cleanMetadata?: boolean;
        includeUnloaded?: boolean;
        isUncommitted?: boolean;
    }): InternalValue<T> | PartialCollectionValueWithIds<T>;
    findAll({ level, parentId, where, includeUnloaded, includePhantom, isUncommitted, }?: Parameters<NormalizedCollection<T>['findAll']>[0]): this;
    where(fun: (data: InternalValue<T> & LokiObj) => boolean): this;
    clear(): this;
    remove({ data, beforeRemove, afterRemove, }: Parameters<NormalizedCollection<T>['remove']>[0]): this;
    sort({ columnDefinitions, orderBy, }: {
        columnDefinitions: NestedField<ScreenBase, NestedFieldTypes, T, any>[];
        orderBy?: Parameters<NormalizedCollection<T>['sort']>[0]['orderBy'];
    }): this;
    filter({ where, groupByKey }: Parameters<NormalizedCollection<T>['filter']>[0]): this;
    update({ data, beforeUpdate, afterUpdate, cleanMetadata, }: Parameters<NormalizedCollection<T>['update']>[0]): InternalValue<T>;
    getIdPathToRecordByIdAndLevel({ id, level, }: Parameters<NormalizedCollection<T>['getIdPathToRecordByIdAndLevel']>[0]): string[];
    getIdPathToRecordByRecord(startRecord: {
        _id: string;
        __parentId?: string;
        __level?: number;
    }): string[];
    createRecord({ data, level, dirty, action, beforeCreate, parentId, isUncommitted, }: Parameters<NormalizedCollection<T>['createRecord']>[0]): InternalValue<T>;
    addRecord({ data, level, cleanMetadata, dirty, action, beforeInsert, afterInsert, parentId, isUncommitted, }: Parameters<NormalizedCollection<T>['addRecord']>[0]): any;
    skip(offset: Parameters<NormalizedCollection<T>['skip']>[0]): this;
    take(limit: Parameters<NormalizedCollection<T>['take']>[0]): this;
    getAncestorIds({ id, level }: Parameters<NormalizedCollection<T>['getAncestorIds']>[0]): string[];
    value({ cleanMetadata, cleanDatabaseMeta, }: {
        cleanMetadata: true;
        cleanDatabaseMeta?: boolean;
    }): PartialCollectionValueWithIds<T>[];
    value({ cleanMetadata, cleanDatabaseMeta, }: {
        cleanMetadata: false;
        cleanDatabaseMeta?: boolean;
    }): InternalValue<T>[];
    value({ cleanMetadata, cleanDatabaseMeta, }: {
        cleanMetadata?: boolean;
        cleanDatabaseMeta?: boolean;
    }): PartialCollectionValueWithIds<T>[];
    value(): PartialCollectionValueWithIds<T>[];
    getValidationStateByColumn(levels: number): CollectionGlobalValidationState;
    getAllServerRecordWithServerSideValidationIssues(): string[];
    getInvalidLoadedRecords({ level, parentId, withoutServerErrors, includePhantom, }?: {
        level?: number | null;
        parentId?: string | null;
        withoutServerErrors?: boolean;
        includePhantom?: boolean;
    }): this;
    getInvalidUnloadedRecords({ level, parentId, withoutServerErrors, includePhantom, }?: {
        level?: number | null;
        parentId?: string | null;
        withoutServerErrors?: boolean;
        includePhantom?: boolean;
    }): this;
    getAllInvalidRecords({ level, parentId, includePhantom, }?: {
        level?: number | null;
        parentId?: string | null;
        includePhantom?: boolean;
    }): this;
    isCollectionValid(): boolean;
    isCollectionDirty(): boolean;
    startRecordTransaction({ recordId, recordLevel, }: Parameters<NormalizedCollection<T>['startRecordTransaction']>[0]): void;
    commitRecord({ recordId, recordLevel }: Parameters<NormalizedCollection<T>['commitRecord']>[0]): boolean;
    cancelRecordTransaction({ recordId, recordLevel, }: Parameters<NormalizedCollection<T>['cancelRecordTransaction']>[0]): void;
}
export {};
//# sourceMappingURL=loki.d.ts.map