import type { ClientNode, Filter, FilterOperator } from '@sage/xtrem-client';
import type { CancelToken } from 'axios';
import type { EnumType } from 'json-to-graphql-query';
import type { ApplicationContext } from '../redux/state';
import type { NodePropertyType } from '../types';
import type { ScreenBaseDefinition } from './screen-base-definition';
export type ExecutableQuery = QueryWrapper<NodeCollection> | QueryEnumWrapper | object | string;
export interface GraphqlCacheSettings {
    key: string;
    version: string;
    locale: string;
    shouldFetchPlatformLiterals: boolean;
}
export declare const queryToGraphQuery: (query: any) => string;
export declare function escapeStringRegexp(input: string): string;
export interface ExecuteGraphqlQueryArgs {
    /** The GraphQL query to execute. */
    query: ExecutableQuery;
    /** The endpoint to run the query against, "/api" by default */
    endpoint?: string;
    /** Cache key components, the query first executed against the locale cache, if not met the server is called. The result is put into the cache */
    axiosCancelToken?: CancelToken;
    /** If set, the cache is not used for fetching data, but the result is stored. */
    forceRefetch?: boolean;
    cacheSettings?: GraphqlCacheSettings;
}
export declare const untrackedExecuteGraphqlQuery: ({ query, endpoint, cacheSettings, axiosCancelToken, forceRefetch, }: ExecuteGraphqlQueryArgs) => Promise<any>;
export declare const executeGraphqlQueryWithCache: ({ query, endpoint, cacheSettings, axiosCancelToken, forceRefetch, node, }: ExecuteGraphqlQueryArgs & {
    node: string;
}) => Promise<any>;
export declare const executeGraphqlQuery: ({ query, endpoint, cacheSettings, axiosCancelToken, forceRefetch, }: ExecuteGraphqlQueryArgs) => Promise<any>;
export declare const covertPageToStringKey: (path: string) => string;
export declare const getHeadersFromApplicationContext: (applicationContext?: ApplicationContext | null) => Record<string, string>;
export type GraphQLFilterOperator = FilterOperator<any>;
export type NonArrayGraphQLFilter = GraphQLFilterOperator | GraphQLFilter | EnumType | undefined;
export type GraphQLFilter<T extends ClientNode = any> = Filter<T>;
export type GraphQLFilterValueType = FilterOperator<any> | GraphQLFilter[] | GraphQLFilter | EnumType | undefined;
export interface GraphQLPropertyObject {
    name: string;
    properties?: GraphQLProperty[];
    isCollection?: boolean;
    options?: GraphQLQueryArguments;
}
export type GraphQLProperty = string | GraphQLPropertyObject;
export interface GraphQLQueryArguments<T extends ClientNode = any> {
    first?: number;
    last?: number;
    after?: string;
    before?: string;
    filter?: GraphQLFilter<T>;
    orderBy?: string[];
}
export interface GraphQLQueryOptions extends GraphQLQueryArguments {
    properties: GraphQLProperty[];
}
export interface GraphQLQuery {
    node: string;
    options: GraphQLQueryOptions;
}
export interface GraphQLRawQuery {
    node: string;
    query: string;
}
export interface QueryFilterOperator {
    _eq?: string | number;
    _ne?: string;
    _gt?: string | number;
    _gte?: string | number;
    _lt?: string | number;
    _lte?: string | number;
    _in?: string[];
    _nin?: string[];
    _regex?: string;
    _options?: string;
    _mod?: number[];
}
export type QueryProperty = string | Object;
export interface QueryEnum {
    __args: {
        name: string;
    };
    __aliasFor?: string;
    enumValues: {
        name: boolean;
    };
}
export interface QueryArguments {
    after?: string;
    before?: string;
    filter?: string;
    first?: number;
    last?: number;
    orderBy?: string;
    skip?: number;
}
export interface QueryBuilderOptions {
    alias?: string;
    properties?: QueryProperty[];
    queryArguments?: QueryArguments;
    noPageInfo?: boolean;
}
export interface PageInfoQuery {
    endCursor?: boolean;
    hasNextPage?: boolean;
    hasPreviousPage?: boolean;
    startCursor?: boolean;
}
export interface PageInfoResult {
    endCursor?: string;
    hasNextPage?: boolean;
    hasPreviousPage?: boolean;
    startCursor?: string;
}
export interface CollectionQuery {
    __args?: QueryArguments;
    pageInfo?: PageInfoQuery;
    totalCount?: boolean;
    edges: {
        node: any;
        cursor?: boolean;
    };
}
export interface TotalCountQuery {
    __aliasFor?: string;
    query: TotalCountSelector;
}
export interface TotalCountSelector {
    __args?: QueryArguments;
    totalCount: true;
}
export interface CollectionQueryResult<T extends ClientNode = any> {
    pageInfo?: PageInfoResult;
    totalCount?: number;
    edges: {
        node?: T;
        cursor?: string;
    }[];
}
interface LookupQuery {
    __args?: {
        _id: string;
    };
}
export interface NodeCollection {
    __aliasFor?: string;
    query: CollectionQuery;
    lookups?: LookupQuery;
}
export interface NodeCollectionResult<T extends ClientNode = any> {
    query: CollectionQueryResult<T>;
}
export interface QueryEnumWrapper {
    [typeName: string]: any;
}
export interface QueryWrapper<T> {
    [pkg: string]: {
        [key: string]: T;
    };
}
export type MixedQueryWrapper = QueryWrapper<NodeCollection> | QueryEnumWrapper;
export interface NavigationPanelData {
    navigationPanelCursor?: string;
    navigationPanelItems: any[];
    hasNextPage: boolean;
}
export declare const removeEdges: (target: NodeCollectionResult, keepPageInfo?: boolean, keepCursor?: boolean) => any;
export declare const removeEdgesDeep: (target: any, keepPageInfo?: boolean, keepCursor?: boolean) => any;
/**
 * Gets all groups along with their aggregations.
 *
 * Returns all groups along with their group key.
 *
 * @export
 * @param {*} target
 * @param {string} [k]
 * @returns {*}
 */
export declare function getGroups(target: any, groupKey?: string): any;
export declare function getAllGroups(input: any): any;
export declare const flattenEdges: (edges: Object[]) => Object[];
export declare const splitNodeName: (nodeName: NodePropertyType) => string[];
export declare const wrapQuery: (nodeName: NodePropertyType, queryObject: any, alias?: string | null) => QueryWrapper<any>;
export declare const unwrapQueryResponse: (nodeName: NodePropertyType, queryResponse: any, alias?: string | null) => any;
export interface GetNodeForLookupOperationsArgs {
    parentElementId?: string;
    level?: number;
    screenDefinition: ScreenBaseDefinition;
}
export declare const getNodeForLookupOperation: ({ parentElementId, screenDefinition, level, }: GetNodeForLookupOperationsArgs) => NodePropertyType;
export declare const wipeCache: () => Promise<void>;
export {};
//# sourceMappingURL=graphql-utils.d.ts.map