import type { ClientNode as metadataService } from '@sage/xtrem-client';
import { type Dict, type WorkflowNode } from '@sage/xtrem-shared';
import type { CancelToken } from 'axios';
import type { OptionsMenuItem } from '../component/container/page/page-types';
import type { ReferenceProperties, TreeProperties } from '../component/field/field-properties';
import type { PropertyValueType } from '../component/field/reference/reference-types';
import type { TableDecoratorProperties } from '../component/field/table/table-component-types';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { OrderByType } from '../component/types';
import { FieldKey } from '../component/types';
import type { ApplicationContext, UiComponentUserSettings } from '../redux/state';
import type { NodePropertyType } from '../types';
import type { GraphQLFilter, NodeCollectionResult, QueryArguments } from './graphql-utils';
import type { DataTypeDetails, FormattedNodeDetails } from './metadata-types';
import type { Page } from './page';
import type { PageDefinition } from './page-definition';
import type { XtremUiPlugin } from './plugin-service';
import type { ScreenBase } from './screen-base';
import type { ScreenBaseDefinition } from './screen-base-definition';
export declare const fetchCollectionDataCount: ({ rootNode, filter, }: {
    rootNode: NodePropertyType;
    filter: string;
}) => Promise<number>;
export declare const fetchCollectionData: ({ bind, elementId, group, nestedFields, node, nodeTypes, queryArguments, rootNode, rootNodeId, screenDefinition, totalCount, treeProperties, }: {
    bind?: PropertyValueType;
    elementId: string;
    group?: {
        key: string;
        value?: string;
        type: FieldKey;
    };
    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
    node?: string;
    nodeTypes?: Dict<FormattedNodeDetails>;
    queryArguments?: QueryArguments;
    rootNode: NodePropertyType;
    rootNodeId: string;
    screenDefinition: ScreenBaseDefinition;
    totalCount?: boolean;
    treeProperties?: TreeProperties<Page>;
}) => Promise<any>;
export declare const fetchCollectionRecord: (screenDefinition: ScreenBaseDefinition, nestedFields: NestedField<ScreenBase, NestedFieldTypes, any, any>[], nodeName: NodePropertyType, recordId: string) => Promise<any>;
export declare const formatNavigationPanelResponse: (navigationPanelResponse: NodeCollectionResult) => any[];
export declare const fetchNavigationPanelData: (screenId: string, screenDefinition: ScreenBaseDefinition, tableDecoratorProperties: TableDecoratorProperties, orderBy?: OrderByType, filter?: GraphQLFilter, first?: number, nodeTypes?: Dict<FormattedNodeDetails>, 
/**
 * If it is an initial page load query for the navigation panel, the option menu is added to the query filter by this method.
 * In other cases (e.g. filter change, sorting change), the collection data service provided filter already contains the currently selected
 * option item.
 *  */
optionMenuItem?: OptionsMenuItem) => Promise<any[]>;
export interface FetchReferenceFieldSuggestionsInput<T extends metadataService = any> {
    after?: string;
    contextNode?: NodePropertyType;
    exactMatch?: boolean;
    fieldId: string;
    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, 'parent' | 'onChange'>;
    filterValue?: string;
    isFilterLimitedToDataset?: boolean;
    level?: number;
    locale?: string;
    parentElementId?: string;
    recordContext?: Dict<any>;
    screenId: string;
}
export declare const fetchReferenceFieldSuggestions: <T extends metadataService = any>({ after, contextNode, exactMatch, fieldId, fieldProperties, filterValue, isFilterLimitedToDataset, level, locale, parentElementId, recordContext, screenId, }: FetchReferenceFieldSuggestionsInput<T>) => Promise<T[]>;
export declare const fetchReferenceFieldData: <T extends metadataService = any>({ after, axiosCancelToken, contextNode, elementId, fieldProperties, filter, group, isFilterLimitedToDataset, level, orderBy, pageSize, parentElementId, recordContext, screenId, valueField, }: {
    after?: string;
    axiosCancelToken?: CancelToken;
    contextNode?: NodePropertyType;
    elementId: string;
    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, "parent" | "onChange">;
    filter?: GraphQLFilter<T>;
    group?: {
        key: string;
        value?: string;
        type: FieldKey;
    };
    isFilterLimitedToDataset?: boolean;
    level?: number;
    orderBy?: OrderByType<T>;
    pageSize?: number;
    parentElementId?: string;
    recordContext?: Dict<any>;
    screenId: string;
    valueField?: any;
}) => Promise<NodeCollectionResult<T>>;
export declare const fetchReferenceFieldDataById: <T extends metadataService = any>({ _id, contextNode, elementId, fieldProperties, level, parentElementId, recordContext, screenId, valueField, }: {
    _id: string;
    contextNode?: NodePropertyType;
    elementId: string;
    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, "parent">;
    level?: number;
    parentElementId?: string;
    recordContext?: Dict<any>;
    screenId: string;
    valueField?: any;
}) => Promise<any>;
export interface FetchRecordDataArgs {
    nodeTypes: Dict<FormattedNodeDetails>;
    recordId?: string;
    requiredSections?: string[];
    screenDefinition: ScreenBaseDefinition;
    screenId: string;
    skipHeaderFields?: boolean;
    includeFieldsWithNoParent?: boolean;
}
export declare const fetchRecordData: ({ requiredSections, screenId, recordId, screenDefinition, nodeTypes, skipHeaderFields, includeFieldsWithNoParent, }: FetchRecordDataArgs) => Promise<any>;
export declare const fetchField: (screenDefinition: ScreenBaseDefinition, fieldProperties: ReadonlyFieldProperties, recordId: string, elementId: string, plugins: Dict<XtremUiPlugin>, nodeTypes: Dict<FormattedNodeDetails>, nodeName?: string, keepPageInfo?: boolean, userSettings?: Dict<Dict<UiComponentUserSettings>>) => Promise<any>;
export interface InitialData {
    navigationPanel: any[];
    values: ScreenBaseDefinition['values'];
}
export interface FetchInitialDataArgs {
    pageDefinition: PageDefinition;
    recordId?: string;
    path?: string;
    applicationContext?: ApplicationContext;
    nodeTypes?: Dict<FormattedNodeDetails>;
    dataTypes?: Dict<DataTypeDetails>;
    /**
     * If the values are provided, they are not fetched from the server.
     * This feature is used to pre-populate page dialogs with data.
     *  */
    values?: Dict<any>;
    isDuplicate?: boolean;
    serviceOptions: Dict<boolean>;
    requiredSections?: string[];
    includeFieldsWithNoParent?: boolean;
}
export declare const fetchInitialData: ({ pageDefinition, recordId, path, applicationContext, nodeTypes, dataTypes, values, isDuplicate, serviceOptions, requiredSections, }: FetchInitialDataArgs) => Promise<InitialData>;
export declare const fetchNestedDefaultValues: ({ screenId, elementId, isNewRow, recordId, nestedElementId, level, data, }: {
    screenId: string;
    elementId: string;
    isNewRow?: boolean;
    recordId?: string;
    nestedElementId?: string;
    level?: number;
    data?: any;
}) => Promise<{
    pageDefaults?: Dict<any>;
    nestedDefaults?: Dict<any>;
}>;
export declare const fetchDefaultValues: (screenDefinition: ScreenBaseDefinition, rootNode: string, requestedFieldIds?: string[], clean?: boolean, nodeTypes?: Dict<FormattedNodeDetails>) => Promise<Dict<any>>;
export declare const fetchWorkflowNodes: () => Promise<WorkflowNode[]>;
//# sourceMappingURL=graphql-service.d.ts.map