import type { ClientNode } from '@sage/xtrem-client';
import type { Dict, FilterType, FiltrableType } from '@sage/xtrem-shared';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { FilterManagerField } from '../component/ui/filter/filter-manager';
import type { NodePropertyType } from '../types';
import type { GraphQLFilter, QueryArguments } from './graphql-utils';
import type { FormattedNodeDetails } from './metadata-types';
import type { ScreenBase } from './screen-base';
export interface Filter<T extends FiltrableType = string> {
    id: string;
    value: Array<{
        filterValue: FilterValue<T>;
        /** Indicates that the filter should be applied against the ID field, it is used with nested objects (e.g reference columns) */
        filterById?: boolean;
        filterType: {
            value: FilterType<T>;
            text: string;
        };
    }>;
}
export type FilterValue<T extends FiltrableType = string> = T extends string ? T | T[] : T;
export declare const getGraphQLFilter: <T extends FiltrableType>(filters: Filter<T>[], nestedFields: FilterManagerField[]) => GraphQLFilter;
export declare const getGraphQLFilterAsString: (queryFilter: GraphQLFilter) => QueryArguments["filter"];
export declare const getFilterAsGraphQLFilterString: (filters: Filter[], nestedFields: FilterManagerField[]) => QueryArguments["filter"];
export declare const mergeGraphQLFilters: <T extends ClientNode = any>(graphQLFilters: (GraphQLFilter<T> | undefined)[]) => any;
export declare const getTypedNestedFields: (screenId: string, node: NodePropertyType, nestedFields: NestedField<ScreenBase, NestedFieldTypes>[], knownNodeTypes: Dict<FormattedNodeDetails>) => FilterManagerField[];
//# sourceMappingURL=filter-service.d.ts.map