import type { ValidationResult } from './screen-base-definition';
export interface ContainerValidationResult {
    allErrors: ValidationResult[];
    blockingErrors: ValidationResult[];
}
export declare const runAndDispatchFieldValidation: (screenId: string, elementId: string, value?: any) => Promise<ValidationResult[] | undefined>;
export declare const dispatchContainerValidation: (screenId: string, elementId: string) => Promise<{
    allErrors: ValidationResult[];
    blockingErrors: ValidationResult[];
}>;
export declare const dispatchFieldsValidation: (elementsId: string[], screenId: string) => Promise<{
    allErrors: ValidationResult[];
    blockingErrors: ValidationResult[];
}>;
export declare const dispatchSetFieldDirty: ({ screenId, elementId }: {
    screenId: string;
    elementId: string;
}) => void;
export declare const dispatchCloseSideBar: ({ screenId, elementId, recordId, }: {
    screenId: string;
    elementId: string;
    recordId: string;
}) => void;
/**
 *
 * @param screenId
 * @param elementId
 * @param validationResult If not validation result is passed in, the field is marked valid.
 */
export declare const dispatchFieldValidation: (screenId: string, elementId: string, validationResult?: ValidationResult[]) => void;
/**
 *
 * @param screenId
 * @param elementId
 * @param validationResult If not validation result is passed in, the field is marked valid.
 */
export declare const dispatchUpdateNestedFieldValidationErrorsForRecord: ({ screenId, elementId, recordId, level, validationResult, isUncommitted, }: {
    screenId: string;
    elementId: string;
    recordId: string;
    validationResult?: ValidationResult[];
    isUncommitted?: boolean;
    level?: number;
}) => void;
//# sourceMappingURL=dispatch-service.d.ts.map